/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss;

import com.alibaba.security.util.StringUtils;
import com.alibaba.security.xss.RichtextFilter;
import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.PolicyException;
import com.alibaba.security.xss.richtext.RichtextPolicy;
import com.alibaba.security.xss.richtext.XppScanner;
import com.alibaba.security.xss.richtext.XssXppScanner;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RichtextFilterImpl
implements RichtextFilter {
    private static final Logger logger = Logger.getLogger(RichtextFilterImpl.class.getName());
    private static final XppScanner DEFAULT_XPP_SCANNER = RichtextFilterImpl.getXppScannerInstanceByCustomPolicy0(RichtextPolicy.CUSTOM_POLICY.getUri());

    public XppScanner getXppScannerInstanceByInternalDefinePolicy(RichtextPolicy policy) {
        try {
            Policy thePolicy = Policy.getInternalDefinePolicyInstance(policy.getUri());
            return new XssXppScanner(thePolicy);
        }
        catch (PolicyException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public XppScanner getXppScannerInstanceByCustomPolicy(String policyUri) {
        return RichtextFilterImpl.getXppScannerInstanceByCustomPolicy0(policyUri);
    }

    private static XppScanner getXppScannerInstanceByCustomPolicy0(String policyUri) {
        Policy policy = null;
        try {
            InputStream inputStream = XssXppScanner.class.getClassLoader().getResourceAsStream(policyUri);
            policy = inputStream != null ? Policy.getCustomerPolicyInstance(inputStream) : Policy.getLoosePolicyInstance();
        }
        catch (PolicyException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return new XssXppScanner(policy);
    }

    public XppScanner getXppScannerInstance() {
        return DEFAULT_XPP_SCANNER;
    }

    public String richtext(String html) {
        return this.getXppScannerInstance().scan(html);
    }

    public String fastRichtext(String html) {
        if (StringUtils.isEmpty(html) || html.indexOf(60) == -1) {
            return html;
        }
        return this.fastRichtext(this.getXppScannerInstance(), html);
    }

    public String fastRichtext(XppScanner scanner, String html) {
        if (StringUtils.isEmpty(html) || html.indexOf(60) == -1) {
            return html;
        }
        return scanner.scan(html);
    }
}

