/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.trie;

import com.alibaba.security.util.trie.Trie;
import com.alibaba.security.util.trie.converter.HostLetterTrieNodeConverter;
import com.alibaba.security.util.trie.converter.TrieNodeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DoubleArrayTrie
implements Trie {
    private static final int BUF_SIZE = 16;
    private static final int UNIT_SIZE = 8;
    private int[] base = null;
    private int[] check = null;
    private TrieNodeConverter converter;
    private int size = 0;
    private int allocSize = 0;
    private boolean[] used = null;
    private List<String> keyList;
    private int keySize;
    private int[] length;
    private int[] value;
    private int progress;
    private int nextCheckPos;
    private int wildcard;
    int errorCode = 0;
    private boolean prefix = true;

    private int resize(int newSize) {
        int[] base2 = new int[newSize];
        int[] check2 = new int[newSize];
        boolean[] used2 = new boolean[newSize];
        if (this.allocSize > 0) {
            System.arraycopy(this.base, 0, base2, 0, this.allocSize);
            System.arraycopy(this.check, 0, check2, 0, this.allocSize);
            System.arraycopy(used2, 0, used2, 0, this.allocSize);
        }
        this.base = base2;
        this.check = check2;
        this.used = used2;
        this.allocSize = newSize;
        return this.allocSize;
    }

    private int fetch(Node parent, List<Node> siblings) {
        if (this.errorCode < 0) {
            return 0;
        }
        int prev = 0;
        for (int i = parent.left; i < parent.right; ++i) {
            if ((this.length != null ? this.length[i] : this.keyList.get(i).length()) < parent.depth) continue;
            String tmp = this.keyList.get(i);
            int cur = 0;
            if ((this.length != null ? this.length[i] : tmp.length()) != parent.depth) {
                int index = this.getIndex(tmp.charAt(parent.depth));
                if (index == -2) {
                    this.errorCode = -1;
                    return 0;
                }
                cur = index == Integer.MIN_VALUE ? Integer.MIN_VALUE : index + 1;
            }
            if (prev > cur) {
                this.errorCode = -3;
                return 0;
            }
            if (cur != prev || siblings.size() == 0) {
                Node tmp_node = new Node();
                tmp_node.depth = parent.depth + 1;
                tmp_node.code = cur;
                tmp_node.left = i;
                if (siblings.size() != 0) {
                    siblings.get((int)(siblings.size() - 1)).right = i;
                }
                siblings.add(tmp_node);
            }
            prev = cur;
        }
        if (siblings.size() != 0) {
            siblings.get((int)(siblings.size() - 1)).right = parent.right;
        }
        return siblings.size();
    }

    private int insert(List<Node> siblings) {
        int i;
        if (this.errorCode < 0) {
            return 0;
        }
        int begin = 0;
        int pos = (siblings.get((int)0).code + 1 > this.nextCheckPos ? siblings.get((int)0).code + 1 : this.nextCheckPos) - 1;
        int nonzero_num = 0;
        boolean first = false;
        if (this.allocSize <= pos) {
            this.resize(pos + 1);
        }
        block0: while (true) {
            if (this.allocSize <= ++pos) {
                this.resize(pos + 1);
            }
            if (this.check[pos] != 0) {
                ++nonzero_num;
                continue;
            }
            if (!first) {
                this.nextCheckPos = pos;
                first = true;
            }
            if (this.allocSize <= (begin = pos - siblings.get((int)0).code) + siblings.get((int)(siblings.size() - 1)).code) {
                double l = 1.05 > 1.0 * (double)this.keySize / (double)(this.progress + 1) ? 1.05 : 1.0 * (double)this.keySize / (double)(this.progress + 1);
                this.resize((int)((double)this.allocSize * l));
            }
            if (this.used[begin]) continue;
            for (i = 1; i < siblings.size(); ++i) {
                if (this.check[begin + siblings.get((int)i).code] == 0) continue;
                continue block0;
            }
            break;
        }
        if (1.0 * (double)nonzero_num / (double)(pos - this.nextCheckPos + 1) >= 0.95) {
            this.nextCheckPos = pos;
        }
        this.used[begin] = true;
        this.size = this.size > begin + siblings.get((int)(siblings.size() - 1)).code + 1 ? this.size : begin + siblings.get((int)(siblings.size() - 1)).code + 1;
        for (i = 0; i < siblings.size(); ++i) {
            this.check[begin + siblings.get((int)i).code] = begin;
        }
        for (i = 0; i < siblings.size(); ++i) {
            int h;
            ArrayList<Node> new_siblings = new ArrayList<Node>();
            if (this.fetch(siblings.get(i), new_siblings) == 0) {
                int n = this.base[begin + siblings.get((int)i).code] = this.value != null ? -this.value[siblings.get((int)i).left] - 1 : -siblings.get((int)i).left - 1;
                if (this.value != null && -this.value[siblings.get((int)i).left] - 1 >= 0) {
                    this.errorCode = -2;
                    return 0;
                }
                ++this.progress;
                continue;
            }
            this.base[begin + siblings.get((int)i).code] = h = this.insert(new_siblings);
        }
        return begin;
    }

    public DoubleArrayTrie() {
        this.prefix = true;
    }

    public DoubleArrayTrie(TrieNodeConverter converter) {
        this.converter = converter == null ? new HostLetterTrieNodeConverter() : converter;
        this.wildcard = this.converter.getSize() + 1;
        this.prefix = true;
    }

    public DoubleArrayTrie(TrieNodeConverter converter, boolean prefix) {
        this.converter = converter == null ? new HostLetterTrieNodeConverter() : converter;
        this.wildcard = this.converter.getSize() + 1;
        this.prefix = prefix;
    }

    void clear() {
        this.check = null;
        this.base = null;
        this.used = null;
        this.allocSize = 0;
        this.size = 0;
        this.converter = null;
    }

    public int getUnitSize() {
        return 8;
    }

    public int getSize() {
        return this.size;
    }

    public int getTotalSize() {
        return this.size * 8;
    }

    int getNonzeroSize() {
        int result = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.check[i] == 0) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int build(List<String> key) {
        if (key == null) {
            return 0;
        }
        return this.build(key, null, null, key.size());
    }

    @Override
    public boolean search(String children) {
        return this.exactMatchSearch(children, 0, 0, 0) >= 0;
    }

    public int build(List<String> keyList, int[] length, int[] value, int keySize) {
        if (keySize > keyList.size() || keyList == null || keySize == 0) {
            return 0;
        }
        this.sort(keyList);
        this.keyList = keyList;
        this.length = length;
        this.keySize = keySize;
        this.value = value;
        this.progress = 0;
        this.resize(512);
        this.base[0] = 1;
        this.nextCheckPos = 0;
        Node root_node = new Node();
        root_node.left = 0;
        root_node.right = keySize;
        root_node.depth = 0;
        ArrayList<Node> siblings = new ArrayList<Node>();
        this.fetch(root_node, siblings);
        this.insert(siblings);
        this.used = null;
        keyList = null;
        return this.errorCode;
    }

    private int getIndex(char c) {
        if (this.converter != null) {
            int pos = this.converter.getPos(c);
            return pos == -1 ? this.converter.getSize() : pos;
        }
        return c;
    }

    private void sort(List<String> keyList) {
        ArrayList<String> tempList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!this.prefix) {
            for (String s : keyList) {
                sb.setLength(0);
                tempList.add(sb.append(s).reverse().toString());
            }
            keyList.clear();
            keyList.addAll(tempList);
        }
        Collections.sort(keyList, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int n1 = s1.length();
                int n2 = s2.length();
                int min = Math.min(n1, n2);
                for (int i = 0; i < min; ++i) {
                    char c2;
                    char c1 = (char)DoubleArrayTrie.this.getIndex(s1.charAt(i));
                    if (c1 == (c2 = (char)DoubleArrayTrie.this.getIndex(s2.charAt(i))) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                    return c1 - c2;
                }
                return n1 - n2;
            }
        });
    }

    public int exactMatchSearch(String key) {
        return this.exactMatchSearch(key, 0, 0, 0);
    }

    public int exactMatchSearch(String key, int pos, int len, int nodePos) {
        int s;
        int i;
        if (this.base == null || key == null) {
            return -2;
        }
        if (len <= 0) {
            len = key.length();
        }
        if (nodePos <= 0) {
            nodePos = 0;
        }
        int result = -1;
        char[] keyChars = key.toCharArray();
        int b = this.base[nodePos];
        if (this.prefix) {
            for (i = pos; i < len; ++i) {
                s = b + this.getIndex(keyChars[i]) + 1;
                if (b != this.check[s]) {
                    if (b == this.check[b + this.wildcard]) {
                        return 0;
                    }
                    return result;
                }
                b = this.base[s];
            }
        } else {
            for (i = len - 1; i >= pos; --i) {
                s = b + this.getIndex(keyChars[i]) + 1;
                if (b != this.check[s]) {
                    if (b == this.check[b + this.wildcard]) {
                        return 0;
                    }
                    return result;
                }
                b = this.base[s];
            }
        }
        s = b;
        int n = this.base[s];
        if (b == this.check[s] && n < 0) {
            result = -n - 1;
        }
        return result;
    }

    public List<Integer> commonPrefixSearch(String key) {
        return this.commonPrefixSearch(key, 0, 0, 0);
    }

    public List<Integer> commonPrefixSearch(String key, int pos, int len, int nodePos) {
        int n;
        int p;
        if (len <= 0) {
            len = key.length();
        }
        if (nodePos <= 0) {
            nodePos = 0;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        char[] keyChars = key.toCharArray();
        int b = this.base[nodePos];
        for (int i = pos; i < len; ++i) {
            p = b;
            n = this.base[p];
            if (b == this.check[p] && n < 0) {
                result.add(-n - 1);
            }
            if (b != this.check[p = b + this.getIndex(keyChars[i]) + 1]) {
                return result;
            }
            b = this.base[p];
        }
        p = b;
        n = this.base[p];
        if (b == this.check[p] && n < 0) {
            result.add(-n - 1);
        }
        return result;
    }

    public void dump() {
        for (int i = 0; i < this.size; ++i) {
            System.err.println("i: " + i + " [" + this.base[i] + ", " + this.check[i] + "]");
        }
    }

    private static class Node {
        int code;
        int depth;
        int left;
        int right;

        private Node() {
        }
    }
}

