/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.expiringmap;

import com.alibaba.security.util.expiringmap.ExpiringMap;
import com.alibaba.security.util.expiringmap.ExpiringMapBuilder;
import java.util.Iterator;
import java.util.Map;

public class ExpiringSet<E> {
    private transient Map<E, Object> map;
    private static final Object PRESENT = new Object();

    public ExpiringSet() {
        this.map = ExpiringMap.builder().build();
    }

    public ExpiringSet(ExpiringMapBuilder<E, Object> builder) {
        this.map = builder == null ? ExpiringMap.builder().build() : builder.build();
    }

    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    public void clear() {
        this.map.clear();
    }

    public static <E> ExpiringSet<E> create(ExpiringMapBuilder<E, Object> builder) {
        return new ExpiringSet<E>(builder);
    }
}

