/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.expiringmap;

import com.alibaba.security.util.AssertUtil;
import com.alibaba.security.util.NamedThreadFactory;
import com.alibaba.security.util.expiringmap.AbstractDelegatedReadWriteLockedConcurrentMap;
import com.alibaba.security.util.expiringmap.ExpirationListener;
import com.alibaba.security.util.expiringmap.ExpirationMode;
import com.alibaba.security.util.expiringmap.ExpiringMapBuilder;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ExpiringMap<K, V>
extends AbstractDelegatedReadWriteLockedConcurrentMap<K, V, ExpiringEntry<K, V>, EntryMap<K, V>> {
    static volatile ScheduledExecutorService EXPIRER;
    static volatile ThreadPoolExecutor LISTENER_SERVICE;
    List<ExpirationListener<K, V>> expirationListeners;
    List<ExpirationListener<K, V>> asyncExpirationListeners;
    private AtomicLong expirationNanos;
    private int maxSize;
    private final ExpirationMode expirationMode;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    ExpiringMap(ExpiringMapBuilder<K, V> builder) {
        super(new EntryLinkedHashMap());
        Class<ExpiringMap> clazz;
        if (EXPIRER == null) {
            clazz = ExpiringMap.class;
            // MONITORENTER : com.alibaba.security.util.expiringmap.ExpiringMap.class
            if (EXPIRER == null) {
                EXPIRER = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("ExpiringMap-Expirer"));
            }
            // MONITOREXIT : clazz
        }
        if (LISTENER_SERVICE == null && builder.getAsyncExpirationListeners() != null) {
            clazz = ExpiringMap.class;
            // MONITORENTER : com.alibaba.security.util.expiringmap.ExpiringMap.class
            if (LISTENER_SERVICE == null) {
                LISTENER_SERVICE = (ThreadPoolExecutor)Executors.newCachedThreadPool(new NamedThreadFactory("ExpiringMap-Listener-%s"));
            }
            // MONITOREXIT : clazz
        }
        if (builder.getExpirationListeners() != null) {
            this.expirationListeners = new CopyOnWriteArrayList<ExpirationListener<K, V>>(builder.getExpirationListeners());
        }
        if (builder.getAsyncExpirationListeners() != null) {
            this.asyncExpirationListeners = new CopyOnWriteArrayList<ExpirationListener<K, V>>(builder.getAsyncExpirationListeners());
        }
        this.expirationMode = builder.getExpirationMode();
        this.expirationNanos = new AtomicLong(TimeUnit.NANOSECONDS.convert(builder.getDuration(), TimeUnit.MILLISECONDS));
        this.maxSize = builder.getMaxSize();
    }

    public static ExpiringMapBuilder<Object, Object> builder() {
        return new ExpiringMapBuilder<Object, Object>();
    }

    public static <K, V> ExpiringMapBuilder<K, V> builder(Class<K> keyCls, Class<V> valueCls) {
        return new ExpiringMapBuilder();
    }

    public static <K, V> ExpiringMap<K, V> create() {
        return new ExpiringMap<Object, Object>(ExpiringMap.builder());
    }

    public synchronized void addExpirationListener(ExpirationListener<K, V> listener) {
        AssertUtil.assertNotNull(listener, "listener");
        if (this.expirationListeners == null) {
            this.expirationListeners = new CopyOnWriteArrayList<ExpirationListener<K, V>>();
        }
        this.expirationListeners.add(listener);
    }

    public synchronized void addAsyncExpirationListener(ExpirationListener<K, V> listener) {
        AssertUtil.assertNotNull(listener, "listener");
        if (this.asyncExpirationListeners == null) {
            this.asyncExpirationListeners = new CopyOnWriteArrayList<ExpirationListener<K, V>>();
        }
        this.asyncExpirationListeners.add(listener);
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            for (ExpiringEntry entry : ((EntryMap)this.entries).values()) {
                entry.cancel();
            }
            ((EntryMap)this.entries).clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V get(Object key) {
        ExpiringEntry<K, V> entry = this.getEntry(key);
        if (entry != null && ExpirationMode.ACCESSED.equals((Object)this.expirationMode)) {
            this.resetEntry(entry, false);
        }
        return entry != null ? (V)entry.getValue() : null;
    }

    public long getExpirationMills() {
        return TimeUnit.NANOSECONDS.toMillis(this.expirationNanos.get());
    }

    public long getExpectedExpirationMills(K key) {
        AssertUtil.assertNotNull(key, "key");
        ExpiringEntry<K, V> entry = this.getEntry(key);
        return entry == null ? -1L : TimeUnit.NANOSECONDS.toMillis(entry.expectedExpiration.get() - System.nanoTime());
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public V put(K key, V value) {
        AssertUtil.assertNotNull((Object)this.expirationMode, "expirationPolicy");
        return super.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        AssertUtil.assertNotNull(key, "key");
        this.writeLock.lock();
        try {
            if (!((EntryMap)this.entries).containsKey(key)) {
                V v = this.putInternal(key, value);
                return v;
            }
            Object v = ((ExpiringEntry)((EntryMap)this.entries).get(key)).getValue();
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        AssertUtil.assertNotNull(key, "key");
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)((EntryMap)this.entries).remove(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            if (entry.cancel()) {
                this.scheduleEntry(((EntryMap)this.entries).first());
            }
            Object v = entry.getValue();
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        AssertUtil.assertNotNull(key, "key");
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)((EntryMap)this.entries).get(key);
            if (entry != null && entry.getValue().equals(value)) {
                ((EntryMap)this.entries).remove(key);
                if (entry.cancel()) {
                    this.scheduleEntry(((EntryMap)this.entries).first());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        AssertUtil.assertNotNull(key, "key");
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)((EntryMap)this.entries).get(key);
            if (entry != null && entry.getValue().equals(oldValue)) {
                this.putInternal(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        this.writeLock.lock();
        try {
            HashSet hashSet = new HashSet(((EntryMap)this.entries).keySet());
            return hashSet;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public void clear() {
                ExpiringMap.this.clear();
            }

            @Override
            public boolean contains(Object value) {
                return ExpiringMap.this.containsValue(value);
            }

            @Override
            public Iterator<V> iterator() {
                return (EntryLinkedHashMap)ExpiringMap.this.entries.new EntryLinkedHashMap.ValueIterator();
            }

            @Override
            public int size() {
                return ExpiringMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public void clear() {
                ExpiringMap.this.clear();
            }

            @Override
            public boolean contains(Object entry) {
                if (!(entry instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)entry;
                return ExpiringMap.this.containsKey(e.getKey());
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return (EntryLinkedHashMap)ExpiringMap.this.entries.new EntryLinkedHashMap.EntryIterator();
            }

            @Override
            public boolean remove(Object entry) {
                if (entry instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)entry;
                    return ExpiringMap.this.remove(e.getKey()) != null;
                }
                return false;
            }

            @Override
            public int size() {
                return ExpiringMap.this.size();
            }
        };
    }

    void notifyListeners(final ExpiringEntry<K, V> entry) {
        if (this.asyncExpirationListeners != null) {
            for (final ExpirationListener listener : this.asyncExpirationListeners) {
                LISTENER_SERVICE.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.expired(entry.key, entry.getValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        if (this.expirationListeners != null) {
            for (final ExpirationListener listener : this.expirationListeners) {
                try {
                    listener.expired(entry.key, entry.getValue());
                }
                catch (Exception exception) {}
            }
        }
    }

    ExpiringEntry<K, V> getEntry(Object key) {
        this.readLock.lock();
        try {
            ExpiringEntry expiringEntry = (ExpiringEntry)((EntryMap)this.entries).get(key);
            return expiringEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    V putInternal(K key, V value) {
        this.writeLock.lock();
        try {
            ExpiringEntry<K, V> entry = (ExpiringEntry<K, V>)((EntryMap)this.entries).get(key);
            Object oldValue = null;
            if (entry == null) {
                entry = new ExpiringEntry<K, V>(key, value, this.expirationNanos);
                if (((EntryMap)this.entries).size() >= this.maxSize) {
                    ExpiringEntry expiredEntry = ((EntryMap)this.entries).first();
                    ((EntryMap)this.entries).remove(expiredEntry.key);
                    this.notifyListeners(expiredEntry);
                }
                ((EntryMap)this.entries).put(key, entry);
                if (((EntryMap)this.entries).size() == 1 || ((EntryMap)this.entries).first().equals(entry)) {
                    this.scheduleEntry(entry);
                }
            } else {
                oldValue = entry.getValue();
                if (!ExpirationMode.ACCESSED.equals((Object)this.expirationMode) && (oldValue == null && value == null || oldValue != null && oldValue.equals(value))) {
                    V v = value;
                    return v;
                }
                entry.setValue(value);
                this.resetEntry(entry, false);
            }
            Object object = oldValue;
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEntry(ExpiringEntry<K, V> entry, boolean scheduleFirstEntry) {
        this.writeLock.lock();
        try {
            boolean scheduled = entry.cancel();
            ((EntryMap)this.entries).reorder(entry);
            if (scheduled || scheduleFirstEntry) {
                this.scheduleEntry(((EntryMap)this.entries).first());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleEntry(ExpiringEntry<K, V> entry) {
        if (entry == null || entry.scheduled) {
            return;
        }
        Runnable runnable = null;
        ExpiringEntry<K, V> expiringEntry = entry;
        synchronized (expiringEntry) {
            if (entry.scheduled) {
                return;
            }
            final WeakReference<ExpiringEntry<K, V>> entryReference = new WeakReference<ExpiringEntry<K, V>>(entry);
            runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ExpiringEntry entry = (ExpiringEntry)entryReference.get();
                    ExpiringMap.this.writeLock.lock();
                    try {
                        if (entry != null && entry.scheduled) {
                            ((EntryMap)ExpiringMap.this.entries).remove(entry.key);
                            ExpiringMap.this.notifyListeners(entry);
                        }
                        try {
                            Iterator iterator = ((EntryMap)ExpiringMap.this.entries).valuesIterator();
                            boolean schedulePending = true;
                            while (iterator.hasNext() && schedulePending) {
                                ExpiringEntry nextEntry = iterator.next();
                                if (nextEntry.expectedExpiration.get() <= System.nanoTime()) {
                                    iterator.remove();
                                    ExpiringMap.this.notifyListeners(nextEntry);
                                    continue;
                                }
                                ExpiringMap.this.scheduleEntry(nextEntry);
                                schedulePending = false;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                    }
                    finally {
                        ExpiringMap.this.writeLock.unlock();
                    }
                }
            };
            ScheduledFuture<?> entryFuture = EXPIRER.schedule(runnable, entry.expectedExpiration.get() - System.nanoTime(), TimeUnit.NANOSECONDS);
            entry.schedule(entryFuture);
        }
    }

    private static <K, V> Map.Entry<K, V> mapEntryFor(final ExpiringEntry<K, V> entry) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return entry.key;
            }

            @Override
            public V getValue() {
                return entry.value;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class EntryLinkedHashMap<K, V>
    extends LinkedHashMap<K, ExpiringEntry<K, V>>
    implements EntryMap<K, V> {
        private static final long serialVersionUID = 1L;

        private EntryLinkedHashMap() {
        }

        @Override
        public boolean containsValue(Object value) {
            for (ExpiringEntry entry : this.values()) {
                Object v = entry.value;
                if (v != value && (value == null || !value.equals(v))) continue;
                return true;
            }
            return false;
        }

        @Override
        public ExpiringEntry<K, V> first() {
            return this.isEmpty() ? null : (ExpiringEntry)this.values().iterator().next();
        }

        @Override
        public void reorder(ExpiringEntry<K, V> value) {
            this.remove(value.key);
            value.resetExpiration();
            this.put(value.key, value);
        }

        @Override
        public Iterator<ExpiringEntry<K, V>> valuesIterator() {
            return this.values().iterator();
        }

        abstract class AbstractHashIterator {
            private final Iterator<Map.Entry<K, ExpiringEntry<K, V>>> iterator;
            private ExpiringEntry<K, V> next;

            AbstractHashIterator() {
                this.iterator = EntryLinkedHashMap.this.entrySet().iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public ExpiringEntry<K, V> getNext() {
                this.next = this.iterator.next().getValue();
                return this.next;
            }

            public void remove() {
                this.iterator.remove();
            }
        }

        public final class EntryIterator
        extends AbstractHashIterator
        implements Iterator<Map.Entry<K, V>> {
            @Override
            public final Map.Entry<K, V> next() {
                return ExpiringMap.mapEntryFor(this.getNext());
            }
        }

        final class ValueIterator
        extends AbstractHashIterator
        implements Iterator<V> {
            ValueIterator() {
            }

            @Override
            public final V next() {
                return this.getNext().value;
            }
        }

        final class KeyIterator
        extends AbstractHashIterator
        implements Iterator<K> {
            KeyIterator() {
            }

            @Override
            public final K next() {
                return this.getNext().key;
            }
        }
    }

    static interface EntryMap<K, V>
    extends Map<K, ExpiringEntry<K, V>> {
        public ExpiringEntry<K, V> first();

        public void reorder(ExpiringEntry<K, V> var1);

        public Iterator<ExpiringEntry<K, V>> valuesIterator();
    }

    static class ExpiringEntry<K, V>
    implements Comparable<ExpiringEntry<K, V>> {
        final AtomicLong expirationNanos;
        final AtomicLong expectedExpiration;
        final K key;
        V value;
        volatile Future<?> entryFuture;
        volatile boolean scheduled;

        ExpiringEntry(K key, V value, AtomicLong expirationNanos) {
            this.key = key;
            this.value = value;
            this.expirationNanos = expirationNanos;
            this.expectedExpiration = new AtomicLong();
            this.resetExpiration();
        }

        @Override
        public int compareTo(ExpiringEntry<K, V> other) {
            if (this.key.equals(other.key)) {
                return 0;
            }
            return this.expectedExpiration.get() < other.expectedExpiration.get() ? -1 : 1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpiringEntry other = (ExpiringEntry)obj;
            if (!this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return this.value.toString();
        }

        synchronized boolean cancel() {
            boolean result = this.scheduled;
            if (this.entryFuture != null) {
                this.entryFuture.cancel(false);
            }
            this.entryFuture = null;
            this.scheduled = false;
            return result;
        }

        synchronized V getValue() {
            return this.value;
        }

        void resetExpiration() {
            this.expectedExpiration.set(this.expirationNanos.get() + System.nanoTime());
        }

        synchronized void schedule(Future<?> entryFuture) {
            this.entryFuture = entryFuture;
            this.scheduled = true;
        }

        synchronized void setValue(V value) {
            this.value = value;
        }
    }
}

