/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.crypto;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static byte[] encTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte[] decTable = new byte[256];

    public static byte[] encodeBytes(byte[] data, boolean wrap) {
        int len = (data.length % 3 == 0 ? data.length / 3 : data.length / 3 + 1) * 4;
        int col = 0;
        if (wrap) {
            len += len / 76 * 2;
        }
        byte[] tmp = new byte[len];
        int pos = 0;
        int val = 0;
        int off = 0;
        for (int i = 0; i < data.length; ++i) {
            val = val << 8 | data[i] & 0xFF;
            pos += 8;
            while (pos > 5) {
                tmp[off++] = encTable[val >> (pos -= 6)];
                if (wrap && ++col >= 76) {
                    tmp[off++] = 13;
                    tmp[off++] = 10;
                    col = 0;
                }
                val &= (1 << pos) - 1;
            }
        }
        if (pos > 0) {
            tmp[off++] = encTable[val << 6 - pos];
            if (wrap && ++col >= 76) {
                tmp[off++] = 13;
                tmp[off++] = 10;
                col = 0;
            }
            if (pos == 2) {
                tmp[off++] = 61;
                tmp[off++] = 61;
            } else if (pos == 4) {
                tmp[off++] = 61;
            }
        }
        return tmp;
    }

    public static String encode(byte[] data, boolean wrap) {
        return new String(Base64.encodeBytes(data, wrap));
    }

    public static String encode(byte[] data) {
        return Base64.encode(data, false);
    }

    public static String encode(String input, String enc, boolean wrap) {
        byte[] data = null;
        try {
            data = input.getBytes(enc);
        }
        catch (Exception e) {
            return null;
        }
        return Base64.encode(data, wrap);
    }

    public static String encode(String input, String enc) {
        return Base64.encode(input, enc, false);
    }

    public static String encode(String input) {
        byte[] data = null;
        try {
            data = input.getBytes();
        }
        catch (Exception e) {
            return null;
        }
        return Base64.encode(data, false);
    }

    public static byte[] decodeBytes(byte[] data) {
        byte c;
        byte[] tmp = new byte[data.length];
        int offset = 0;
        int pos = 0;
        int val = 0;
        for (int i = 0; i < data.length && (c = data[i]) != 61; ++i) {
            if (c == 13 || c == 10) continue;
            val = val << 6 | decTable[c];
            pos += 6;
            while (pos > 7) {
                tmp[offset++] = (byte)(val >> (pos -= 8));
                val &= (1 << pos) - 1;
            }
        }
        byte[] rt = new byte[offset];
        System.arraycopy(tmp, 0, rt, 0, offset);
        return rt;
    }

    public static String decode(byte[] src, String enc) {
        try {
            return new String(Base64.decodeBytes(src), enc);
        }
        catch (UnsupportedEncodingException e1) {
            return null;
        }
    }

    public static String decode(String src, String enc) {
        return Base64.decode(src.getBytes(), enc);
    }

    public static String decode(String src) {
        return new String(Base64.decodeBytes(src.getBytes()));
    }

    public static void main(String[] args) {
        String encode = "\u6625\u8282\u5373\u5c06\u5230\u6765\u4e4b\u9645\uff0c\u5982\u4f55\u653e\u5047\uff0c\u653e\u54ea\u51e0\u5929\u6210\u4e3a\u4e86\u516c\u4f17\u5173\u5fc3\u7684\u70ed\u70b9\u95ee\u9898\u3002\u800c\u6839\u636e\u56fd\u52a1\u9662\u4e0b\u53d1\u7684\u76f8\u5173\u901a\u77e5\uff0c2011\u5e74\u6625\u8282\u653e\u5047\u5b89\u6392\u5df2\u7ecf\u51fa\u7089\u3002\u5177\u4f53\u65e5\u671f\u4ece2\u67082\u65e5\uff0c\u5373\u5927\u5e74\u4e09\u5341\u5f00\u59cb\u653e2011\u5e741\u670827\u65e5...\u7504\u5b50\u4e39\u4e0e\u592a\u592a\u6c6a\u8bd7\u8bd7\uff0c26\u65e5\u5230\u6d77\u6d0b\u516c\u56ed\u51fa\u5e2d\u300a\u6d77\u6d0b\u516c\u56ed\u68a6\u5e7b\u6c34\u90fd\u63ed\u5e55\u793c\u300b\uff0c\u8054\u540c\u7279\u9996\u66fe\u836b\u6743\u3001\u6d77\u6d0b\u516c\u56ed\u4e3b\u5e2d\u76db\u667a\u6587\u7b49\u4e00\u8d77\u4e3b\u6301\u63ed\u5e55\u4eea\u5f0f\u3002\u76db\u667a\u6587\u5f88\u82b1\u5fc3\u601d\uff0c\u7279\u522b...";
        System.out.println(Base64.decode(Base64.encode(encode)).equals(encode));
    }

    static {
        for (int i = 0; i < encTable.length; ++i) {
            Base64.decTable[Base64.encTable[i]] = (byte)i;
        }
    }
}

