/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util.asapi.codec;

import com.alibaba.security.util.PushbackableString;
import com.alibaba.security.util.asapi.Codec;

public class CSSCodec
extends Codec {
    private static final Character REPLACEMENT = Character.valueOf('\ufffd');

    @Override
    public String encodeChar(char[] immune, char c) {
        if (CSSCodec.containsCharacter(c, immune)) {
            return String.valueOf(c);
        }
        String hex = Codec.getHex(c);
        if (hex == null) {
            return String.valueOf(c);
        }
        return "\\" + hex + " ";
    }

    @Override
    public int decodeChar(PushbackableString input) {
        int c;
        int i;
        input.mark();
        int first = input.next();
        if (first == -1 || first != 92) {
            input.reset();
            return -1;
        }
        int second = input.next();
        if (second == -1) {
            input.reset();
            return -1;
        }
        switch (second) {
            case 13: {
                if (input.peek(10)) {
                    input.next();
                }
            }
            case 0: 
            case 10: 
            case 12: {
                return this.decodeChar(input);
            }
        }
        if (!PushbackableString.isHexDigit(second)) {
            return second;
        }
        StringBuilder sb = new StringBuilder();
        sb.append((char)second);
        for (i = 0; i < 5 && (c = input.next()) != -1 && !Character.isWhitespace(c); ++i) {
            if (!PushbackableString.isHexDigit(c)) {
                input.pushback((char)c);
                break;
            }
            sb.append((char)c);
        }
        try {
            i = Integer.parseInt(sb.toString(), 16);
            if (Character.isValidCodePoint(i)) {
                return (char)i;
            }
            return REPLACEMENT.charValue();
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Received a NumberFormateException parsing a string verified to be hex", e);
        }
    }
}

