/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.util;

import com.alibaba.security.util.StringUtils;
import java.util.regex.Pattern;

public class IpAddressUtil {
    private static final int INADDR4SZ = 4;
    private static final int INADDR16SZ = 16;
    private static final int INT16SZ = 2;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    private IpAddressUtil() {
    }

    public static boolean isIpAddress(String address) {
        return IpAddressUtil.isIpv4Address(address) || IpAddressUtil.isIpv6Address(address);
    }

    public static boolean isIpv4Address(String host) {
        if (host == null) {
            return false;
        }
        return IPV4_PATTERN.matcher(host).matches();
    }

    public static boolean isIpv6Address(String host) {
        if (host == null || host.isEmpty()) {
            return false;
        }
        if (host.charAt(0) == '[') {
            return host.length() > 2 && host.charAt(host.length() - 1) == ']';
        }
        return false;
    }

    public static String convertIpBytesToString(byte[] ip) {
        int size = ip.length * 8;
        int ipPointer = 0;
        char[] out = new char[size];
        int i = 0;
        while (i < size) {
            if (i % 8 == 0) {
                ipPointer = ip[i / 8];
            }
            out[i] = (ipPointer & 0x80) != 0 ? 49 : 48;
            ++i;
            ipPointer = (byte)(ipPointer << 1);
        }
        return new String(out);
    }

    public static byte[] textToNumericFormatV6(String src) {
        if (src == null || src.length() < 2) {
            return null;
        }
        char[] srcb = src.toCharArray();
        byte[] dst = new byte[16];
        int srcb_length = srcb.length;
        int pc = src.indexOf("%");
        if (pc == srcb_length - 1) {
            return null;
        }
        if (pc != -1) {
            srcb_length = pc;
        }
        int colonp = -1;
        int i = 0;
        int j = 0;
        if (srcb[i] == ':' && srcb[++i] != ':') {
            return null;
        }
        int curtok = i;
        boolean sawXdigit = false;
        int val = 0;
        while (i < srcb_length) {
            char ch;
            int chval;
            if ((chval = Character.digit(ch = srcb[i++], 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    return null;
                }
                sawXdigit = true;
                continue;
            }
            if (ch == ':') {
                curtok = i;
                if (!sawXdigit) {
                    if (colonp != -1) {
                        return null;
                    }
                    colonp = j;
                    continue;
                }
                if (i == srcb_length) {
                    return null;
                }
                if (j + 2 > 16) {
                    return null;
                }
                dst[j++] = (byte)(val >> 8 & 0xFF);
                dst[j++] = (byte)(val & 0xFF);
                sawXdigit = false;
                val = 0;
                continue;
            }
            if (ch == '.' && j + 4 <= 16) {
                String ia4 = src.substring(curtok, srcb_length);
                int dot_count = 0;
                int index = 0;
                while ((index = ia4.indexOf(46, index)) != -1) {
                    ++dot_count;
                    ++index;
                }
                if (dot_count != 3) {
                    return null;
                }
                byte[] v4addr = IpAddressUtil.textToNumericFormatV4(ia4);
                if (v4addr == null) {
                    return null;
                }
                for (int k = 0; k < 4; ++k) {
                    dst[j++] = v4addr[k];
                }
                sawXdigit = false;
                break;
            }
            return null;
        }
        if (sawXdigit) {
            if (j + 2 > 16) {
                return null;
            }
            dst[j++] = (byte)(val >> 8 & 0xFF);
            dst[j++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            int n = j - colonp;
            if (j == 16) {
                return null;
            }
            for (i = 1; i <= n; ++i) {
                dst[16 - i] = dst[colonp + n - i];
                dst[colonp + n - i] = 0;
            }
            j = 16;
        }
        if (j != 16) {
            return null;
        }
        byte[] newdst = IpAddressUtil.convertFromIPv4MappedAddress(dst);
        if (newdst != null) {
            return newdst;
        }
        return dst;
    }

    public static byte[] convertFromIPv4MappedAddress(byte[] addr) {
        if (IpAddressUtil.isIPv4MappedAddress(addr)) {
            byte[] newAddr = new byte[4];
            System.arraycopy(addr, 12, newAddr, 0, 4);
            return newAddr;
        }
        return null;
    }

    private static boolean isIPv4MappedAddress(byte[] addr) {
        if (addr.length < 16) {
            return false;
        }
        return addr[0] == 0 && addr[1] == 0 && addr[2] == 0 && addr[3] == 0 && addr[4] == 0 && addr[5] == 0 && addr[6] == 0 && addr[7] == 0 && addr[8] == 0 && addr[9] == 0 && addr[10] == -1 && addr[11] == -1;
    }

    public static byte[] textToNumericFormatV4(String src) {
        int fullAddr = IpAddressUtil.convertIpv4ToInt(src);
        if (fullAddr == -1) {
            return null;
        }
        return IpAddressUtil.intToByteArray(fullAddr);
    }

    public static String convertIpv6ToString(String ip) {
        byte[] bytes = IpAddressUtil.textToNumericFormatV6(ip);
        if (bytes == null) {
            return null;
        }
        return IpAddressUtil.convertIpBytesToString(bytes);
    }

    public static String convertIpv4ToString(String ip) {
        int fullAddr = IpAddressUtil.convertIpv4ToInt(ip);
        if (fullAddr == Integer.MIN_VALUE) {
            return null;
        }
        char[] out = new char[32];
        int i = 0;
        while (i < 32) {
            out[i] = (fullAddr & Integer.MIN_VALUE) != 0 ? 49 : 48;
            ++i;
            fullAddr <<= 1;
        }
        return new String(out);
    }

    private static int convertIpv4ToInt(String ip) {
        int len = ip.length();
        if (len == 0 || len > 15) {
            return Integer.MIN_VALUE;
        }
        int addr = 0;
        int fullAddr = 0;
        for (int i = 0; i < len; ++i) {
            char digit = ip.charAt(i);
            if (digit != '.') {
                addr = addr * 10 + (digit - 48);
                continue;
            }
            fullAddr = fullAddr << 8 | addr;
            addr = 0;
        }
        return fullAddr << 8 | addr;
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static boolean isNotStandardIP(String host) {
        if (host.contains(".")) {
            String topDomain = host.substring(host.lastIndexOf(".") + 1);
            if (StringUtils.isDigits(topDomain) || topDomain.startsWith("0x")) {
                String[] ipParts = host.split("\\.");
                if (ipParts.length != 4) {
                    return true;
                }
                for (String ipPart : ipParts) {
                    if (IpAddressUtil.isValidIpPart(ipPart)) continue;
                    return true;
                }
            }
        } else {
            if (StringUtils.isDigits(host)) {
                return true;
            }
            if (host.startsWith("0x")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidIpPart(String ipPart) {
        if (!StringUtils.isDigits(ipPart)) {
            return false;
        }
        if (ipPart.length() > 3) {
            return false;
        }
        return ipPart.length() <= 1 || !ipPart.startsWith("0");
    }
}

