/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.url.ssrf;

import com.alibaba.security.net.NetHooksEvent;
import com.alibaba.security.net.NetHooksEventListener;
import com.alibaba.security.url.SSRFUnsafeConnectionError;
import com.alibaba.security.url.exception.GlobalSSRFThrowableFactory;
import com.alibaba.security.url.ssrf.SSRFCheckerImpl;
import com.alibaba.security.url.ssrf.checkcondition.SSRFNetHooksCheckCondition;
import com.alibaba.securitysdk.logging.api.SecType;
import com.alibaba.securitysdk.logging.api.factories.LoggerManager;
import com.alibaba.securitysdk.logging.api.loggers.SecurityModifiedLogger;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SSRFNetHooksEventListener
implements NetHooksEventListener {
    protected final Logger logger = Logger.getLogger(SSRFNetHooksEventListener.class.getName());
    private static final SecurityModifiedLogger SEC_LOGGER = (SecurityModifiedLogger)LoggerManager.getLogger(SecurityModifiedLogger.class);
    protected static final String LOG_CONNECT_FORMAT = "Connecting: %s";
    protected static final String LOG_INFO_FORMAT = "Address %s is not allowed to connect!";
    private final List<SSRFNetHooksCheckCondition> checkConditions;

    public SSRFNetHooksEventListener(SSRFNetHooksCheckCondition ... conditions) {
        this.checkConditions = Collections.unmodifiableList(Arrays.asList(conditions));
    }

    @Override
    public void handleBeforeTcpConnect(NetHooksEvent event) {
        InetAddress address = event.getInetAddress();
        this.log(LOG_CONNECT_FORMAT, address);
        this.check(address);
    }

    protected void check(InetAddress address) {
        for (SSRFNetHooksCheckCondition checkCondition : this.checkConditions) {
            if (!checkCondition.needsCheck(address)) continue;
            boolean allowedAddress = SSRFCheckerImpl.isAllowedAddress(address);
            SEC_LOGGER.logBoolean(SecType.SSRF, (Object)address.toString(), allowedAddress);
            if (allowedAddress) continue;
            this.log(LOG_INFO_FORMAT, address);
            this.throwsErrorOrRuntimeException(checkCondition, address);
        }
    }

    private void throwsErrorOrRuntimeException(SSRFNetHooksCheckCondition checkCondition, InetAddress address) {
        if (checkCondition.isCustomThrowable()) {
            throw GlobalSSRFThrowableFactory.defaultFactory().newRuntimeException("unsafe address", address);
        }
        throw new SSRFUnsafeConnectionError("unsafe address", address);
    }

    protected void log(String format, InetAddress address) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, String.format(format, address));
        }
    }
}

