/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader.parser;

import com.alibaba.security.resource.ResourceParseException;
import com.alibaba.security.resource.ssrf.config.xml.Domain;
import com.alibaba.security.resource.ssrf.config.xml.Domains;
import com.alibaba.security.resource.ssrf.config.xml.Excludedhosts;
import com.alibaba.security.resource.ssrf.config.xml.Hosts;
import com.alibaba.security.resource.ssrf.config.xml.Intranethosts;
import com.alibaba.security.resource.ssrf.config.xml.Ip;
import com.alibaba.security.resource.ssrf.config.xml.Ips;
import com.alibaba.security.resource.ssrf.config.xml.Ipv6;
import com.alibaba.security.resource.ssrf.config.xml.MatcherType;
import com.alibaba.security.resource.ssrf.config.xml.Ssrf;
import com.alibaba.security.resource.ssrf.config.xml.Trustedhosts;
import com.alibaba.security.util.AssertUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SsrfXmlParser {
    private static final Logger logger = Logger.getLogger(SsrfXmlParser.class.getName());
    private InputStream inputStream;

    public SsrfXmlParser(InputStream inputStream) {
        AssertUtil.assertNotNull(inputStream, "The inputStream should not be null.");
        this.inputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ssrf parse() {
        Ssrf ssrf;
        block8: {
            ssrf = null;
            try {
                if (this.inputStream == null) break block8;
                XMLInputFactory factory = XMLInputFactory.newInstance();
                try (XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(this.inputStream);){
                    int event = xmlStreamReader.getEventType();
                    while (true) {
                        if (event == 1) {
                            ssrf = this.prepareSsrf(xmlStreamReader, ssrf);
                        }
                        if (!xmlStreamReader.hasNext()) {
                            break;
                        }
                        event = xmlStreamReader.next();
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Fail to parse ssrf configured file.", e);
            }
        }
        return ssrf;
    }

    private Ssrf prepareSsrf(XMLStreamReader xmlStreamReader, Ssrf ssrf) throws XMLStreamException {
        String name = xmlStreamReader.getName().getLocalPart();
        if (TAG.SSRF_TAG.name.equals(name)) {
            ssrf = ssrf == null ? new Ssrf() : ssrf;
        } else if (TAG.INTRANET_TAG.name.equals(name)) {
            AssertUtil.assertNotNull(ssrf, "ssrf should not be null.");
            ssrf.setIntranethosts(new Intranethosts());
            xmlStreamReader.nextTag();
            this.parseHosts(xmlStreamReader, ssrf.getIntranethosts());
        } else if (TAG.EXCLUDED_TAG.name.equals(name)) {
            AssertUtil.assertNotNull(ssrf, "ssrf should not be null.");
            ssrf.setExcludedhosts(new Excludedhosts());
            xmlStreamReader.nextTag();
            this.parseHosts(xmlStreamReader, ssrf.getExcludedhosts());
        } else if (TAG.TRUSTED_TAG.name.equals(name)) {
            AssertUtil.assertNotNull(ssrf, "ssrf should not be null.");
            ssrf.setTrustedhosts(new Trustedhosts());
            xmlStreamReader.nextTag();
            this.parseHosts(xmlStreamReader, ssrf.getTrustedhosts());
        }
        return ssrf;
    }

    private String parseHosts(XMLStreamReader xmlStreamReader, Hosts hosts) throws XMLStreamException {
        String name = xmlStreamReader.getName().getLocalPart();
        switch (xmlStreamReader.getEventType()) {
            case 1: {
                if (name.equals(TAG.DOMAINS_TAG.name)) {
                    hosts.setDomains(new Domains());
                    break;
                }
                if (!name.equals(TAG.IPS_TAG.name)) break;
                hosts.setIps(new Ips());
                break;
            }
            case 2: {
                if (!name.equals(TAG.INTRANET_TAG.name) && !name.equals(TAG.EXCLUDED_TAG.name) && !name.equals(TAG.TRUSTED_TAG.name)) break;
                return name;
            }
        }
        xmlStreamReader.nextTag();
        this.parseItem(xmlStreamReader, hosts);
        return this.parseHosts(xmlStreamReader, hosts);
    }

    private void parseItem(XMLStreamReader xmlStreamReader, Hosts hosts) {
        String name = xmlStreamReader.getName().getLocalPart();
        if (xmlStreamReader.getEventType() == 1) {
            if (name.equals(TAG.DOMAIN_TAG.name)) {
                ArrayList<Domain> domainList = hosts.getDomains().getDomain();
                domainList = domainList == null ? new ArrayList<Domain>() : domainList;
                domainList.add(this.parseDomain(xmlStreamReader));
            } else if (name.equals(TAG.IP_TAG.name)) {
                ArrayList<Ip> ipList = hosts.getIps().getIp();
                ipList = ipList == null ? new ArrayList<Ip>() : ipList;
                Ip ip = new Ip();
                ip.setValue(this.parseIp(xmlStreamReader));
                ipList.add(ip);
            } else if (name.equals(TAG.IPV6_TAG.name)) {
                ArrayList<Ipv6> ipList = hosts.getIps().getIpv6();
                ipList = ipList == null ? new ArrayList<Ipv6>() : ipList;
                Ipv6 ipv6 = new Ipv6();
                ipv6.setValue(this.parseIp(xmlStreamReader));
                ipList.add(ipv6);
            }
        }
    }

    private Domain parseDomain(XMLStreamReader xmlStreamReader) {
        Domain domain = new Domain();
        int n = xmlStreamReader.getAttributeCount();
        block4: for (int i = 0; i < n; ++i) {
            ATTRIBUTE attribute = ATTRIBUTE.getByName(xmlStreamReader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case VALUE: {
                    domain.setValue(xmlStreamReader.getAttributeValue(i));
                    continue block4;
                }
                case MATCHERTYPE: {
                    domain.setMatcherType(MatcherType.fromValue(xmlStreamReader.getAttributeValue(i)));
                    continue block4;
                }
            }
        }
        return domain;
    }

    private String parseIp(XMLStreamReader xmlStreamReader) {
        int n = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            ATTRIBUTE attribute = ATTRIBUTE.getByName(xmlStreamReader.getAttributeName(i).getLocalPart());
            switch (attribute) {
                case VALUE: {
                    return xmlStreamReader.getAttributeValue(i);
                }
            }
        }
        throw new ResourceParseException();
    }

    private static enum ATTRIBUTE {
        VALUE("value"),
        MATCHERTYPE("matcherType");

        private String name;
        private static final Map<String, ATTRIBUTE> STRING_TO_ENUM;

        private ATTRIBUTE(String name) {
            this.name = name;
        }

        public static ATTRIBUTE getByName(String name) {
            return STRING_TO_ENUM.get(name);
        }

        public String toString() {
            return this.name;
        }

        static {
            STRING_TO_ENUM = new HashMap<String, ATTRIBUTE>();
            for (ATTRIBUTE attri : ATTRIBUTE.values()) {
                STRING_TO_ENUM.put(attri.toString(), attri);
            }
        }
    }

    private static enum TAG {
        SSRF_TAG("ssrf"),
        INTRANET_TAG("intranethosts"),
        EXCLUDED_TAG("excludedhosts"),
        TRUSTED_TAG("trustedhosts"),
        DOMAINS_TAG("domains"),
        DOMAIN_TAG("domain"),
        IPS_TAG("ips"),
        IP_TAG("ip"),
        IPV6_TAG("ipv6");

        private String name;
        private static final Map<String, TAG> STRING_TO_ENUM;

        private TAG(String name) {
            this.name = name;
        }

        public static TAG getByName(String name) {
            return STRING_TO_ENUM.get(name);
        }

        public String toString() {
            return this.name;
        }

        static {
            STRING_TO_ENUM = new HashMap<String, TAG>();
            for (TAG tag : TAG.values()) {
                STRING_TO_ENUM.put(tag.toString(), tag);
            }
        }
    }
}

