/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.ssrf.loader.formatter;

import com.alibaba.security.resource.ssrf.loader.formatter.Domain2StringListFormatter;
import com.alibaba.security.resource.ssrf.loader.formatter.Ips2SubnetMasksStringListFormatter;
import com.alibaba.security.resource.ssrf.loader.formatter.Ipv6s2SubnetMaskStringListFormatter;
import com.alibaba.security.resource.ssrf.loader.formatter.StringListFormatter;
import com.alibaba.security.url.exception.IllegalModifySSRFMasksException;
import com.alibaba.security.url.model.DomainMask;
import com.alibaba.security.url.model.SSRFMatcherEnum;
import com.alibaba.security.url.model.SubnetMask;
import com.alibaba.security.util.MatcherMasksParsers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SSRFMatcherParamsFormatters {
    private static StringListFormatter<SubnetMask> string2Ipv6SubnetMaskFormatter = new Ipv6s2SubnetMaskStringListFormatter();
    private static StringListFormatter<SubnetMask> string2SubnetMaskFormatter = new Ips2SubnetMasksStringListFormatter();
    private static StringListFormatter<DomainMask> domain2StringListFormatter = new Domain2StringListFormatter();

    public static List<String> format(SSRFMatcherEnum ssrfMatcherEnum, List<String> masks) {
        if (ssrfMatcherEnum == null || masks == null) {
            return Collections.emptyList();
        }
        if (ssrfMatcherEnum.isDomain()) {
            ArrayList<DomainMask> domainMasks = new ArrayList<DomainMask>();
            for (String mask : masks) {
                domainMasks.add(MatcherMasksParsers.parse(ssrfMatcherEnum, mask, DomainMask.class));
            }
            return SSRFMatcherParamsFormatters.formatDomainMasks(domainMasks);
        }
        ArrayList<SubnetMask> subnetMasks = new ArrayList<SubnetMask>();
        for (String mask : masks) {
            subnetMasks.add(MatcherMasksParsers.parse(ssrfMatcherEnum, mask, SubnetMask.class));
        }
        return SSRFMatcherParamsFormatters.formatSubnetMasks(ssrfMatcherEnum, subnetMasks);
    }

    public static List<String> formatSubnetMasks(SSRFMatcherEnum ssrfMatcherEnum, List<SubnetMask> masks) {
        if (ssrfMatcherEnum == null || masks == null || masks.isEmpty()) {
            return Collections.emptyList();
        }
        if (ssrfMatcherEnum == SSRFMatcherEnum.INTRANET_IP || ssrfMatcherEnum == SSRFMatcherEnum.EXCLUDED_IP) {
            return string2SubnetMaskFormatter.format(masks);
        }
        if (ssrfMatcherEnum == SSRFMatcherEnum.INTRANET_IPV6 || ssrfMatcherEnum == SSRFMatcherEnum.EXCLUDED_IPV6) {
            return string2Ipv6SubnetMaskFormatter.format(masks);
        }
        if (ssrfMatcherEnum == SSRFMatcherEnum.TRUSTED_IP) {
            return string2SubnetMaskFormatter.format(masks);
        }
        throw new IllegalModifySSRFMasksException("Unmatchable " + ssrfMatcherEnum.value() + " and mask type " + SubnetMask.class);
    }

    public static List<String> formatDomainMasks(List<DomainMask> mask) {
        if (mask == null || mask.isEmpty()) {
            return Collections.emptyList();
        }
        return domain2StringListFormatter.format(mask);
    }
}

