/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.safeurl.matcher;

import com.alibaba.security.resource.safeurl.loader.SafeUrlMatcherEnum;
import com.alibaba.security.resource.safeurl.matcher.SafeUrlMatchable;
import com.alibaba.security.util.matcher.StringMatcher;
import java.util.Map;

public class SafeUrlMatcher
implements SafeUrlMatchable {
    private static final String DEFAULT_ID = "";
    private Map<SafeUrlMatcherEnum, Map<String, StringMatcher>> rootNodeMap;
    private Map<SafeUrlMatcherEnum, Map<String, StringMatcher>> observedRootNodeMap;

    public SafeUrlMatcher(Map<SafeUrlMatcherEnum, Map<String, StringMatcher>> rootNodeMap, Map<SafeUrlMatcherEnum, Map<String, StringMatcher>> observedRootNodeMap) {
        this.rootNodeMap = rootNodeMap;
        this.observedRootNodeMap = observedRootNodeMap;
    }

    @Override
    public boolean matches(String text, String safeUrlMaterEnumName, String id) {
        return this.matches(text, safeUrlMaterEnumName, id, false);
    }

    @Override
    public boolean observedMatches(String text, String safeUrlMaterEnumName, String id) {
        return this.matches(text, safeUrlMaterEnumName, id, true);
    }

    public boolean matches(String text, String safeUrlMaterEnumName, String id, boolean isObserved) {
        SafeUrlMatcherEnum ssrfMatcherEnum;
        Map<SafeUrlMatcherEnum, Map<String, StringMatcher>> map = isObserved ? this.observedRootNodeMap : this.rootNodeMap;
        Map<String, StringMatcher> stringStringMatcherMap = map.get((Object)(ssrfMatcherEnum = SafeUrlMatcherEnum.fromValue(safeUrlMaterEnumName)));
        if (stringStringMatcherMap != null) {
            StringMatcher matcher = stringStringMatcherMap.get(id);
            if (stringStringMatcherMap.containsKey(id)) {
                return matcher.matches(text);
            }
        }
        return false;
    }

    @Override
    public boolean safeUrlMatches(String text, String id, boolean isObserved) {
        return this.matches(text, SafeUrlMatcherEnum.SAFE_URL.value(), id, isObserved);
    }

    @Override
    public boolean blockUrlMatches(String text, String id, boolean isObserved) {
        return this.matches(text, SafeUrlMatcherEnum.BLOCK_URL.value(), id, isObserved);
    }

    @Override
    public boolean defaultSafeUrlMatches(String text, boolean isObserved) {
        return this.matches(text, SafeUrlMatcherEnum.SAFE_URL.value(), DEFAULT_ID, isObserved);
    }

    @Override
    public boolean defaultBlockUrlMatches(String text, boolean isObserved) {
        return this.matches(text, SafeUrlMatcherEnum.BLOCK_URL.value(), DEFAULT_ID, isObserved);
    }
}

