/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource.safeurl.loader.resolver;

import com.alibaba.security.resource.safeurl.loader.resolver.AbstractSyncSafeUrlResolver;
import com.alibaba.security.resource.safeurl.loader.resolver.SafeUrlResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CompositeSafeUrlResolver
extends AbstractSyncSafeUrlResolver {
    private List<SafeUrlResolver> resolvers;
    private static final Class<AbstractSyncSafeUrlResolver> ABSTRACT_SYNC_SAFE_URL_RESOLVER_CLASS = AbstractSyncSafeUrlResolver.class;

    public CompositeSafeUrlResolver(SafeUrlResolver ... resolvers) {
        this.resolvers = Collections.unmodifiableList(Arrays.asList(resolvers));
    }

    @Override
    void resolve() {
        for (SafeUrlResolver resolver : this.resolvers) {
            if (!ABSTRACT_SYNC_SAFE_URL_RESOLVER_CLASS.isInstance(resolver)) continue;
            AbstractSyncSafeUrlResolver syncSafeUrlResolver = ABSTRACT_SYNC_SAFE_URL_RESOLVER_CLASS.cast(resolver);
            this.mergeSafeDomainsList(syncSafeUrlResolver.resolveSafeDomains().values());
            this.mergeBlockDomainsList(syncSafeUrlResolver.resolveBlockDomains().values());
        }
    }

    @Override
    public void reset() {
        for (SafeUrlResolver resolver : this.resolvers) {
            resolver.reset();
        }
        super.reset();
    }

    public List<SafeUrlResolver> getResolvers() {
        return this.resolvers;
    }
}

