/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.resource;

import com.alibaba.security.config.ConfigLoader;
import com.alibaba.security.config.SecurityConfig;
import com.alibaba.security.resource.base.BaseConfig;
import com.alibaba.security.resource.base.BaseConfigJsonParser;
import com.alibaba.securitysdk.logging.api.factories.LoggerManager;
import com.alibaba.securitysdk.logging.api.loggers.SimpleLogger;
import com.alibaba.securitysdk.resource.TypedFileResourceLoader;
import com.alibaba.securitysdk.resource.exception.ResourceLoadingException;
import com.alibaba.securitysdk.resource.impl.CompositeResourceLoader;
import java.nio.file.Path;
import java.util.Map;
import java.util.logging.Logger;

public class LoggableBaseConfigCompositeResourceLoader<R>
extends CompositeResourceLoader<R> {
    private static final SimpleLogger SIMPLE_LOGGER = (SimpleLogger)LoggerManager.getLogger(SimpleLogger.class);
    private static final String EAGLEEYE_LOGGING_GLOBAL_CONTEXT_CLASS = "com.alibaba.securitysdk.logging.context.GlobalContext";
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final SecurityConfig SECURITY_CONFIG = ConfigLoader.loadSecurityConfig();
    private boolean isAbsoluteFilePath;

    public LoggableBaseConfigCompositeResourceLoader(Path path, TypedFileResourceLoader<R> ... resourceLoaders) {
        this(path, false, true, resourceLoaders);
    }

    public LoggableBaseConfigCompositeResourceLoader(Path path, boolean needLock, TypedFileResourceLoader<R> ... resourceLoaders) {
        this(path, needLock, true, resourceLoaders);
    }

    LoggableBaseConfigCompositeResourceLoader(Path path, boolean needLock, boolean isAbsoluteFilePath, TypedFileResourceLoader<R> ... resourceLoaders) {
        super(path, needLock, resourceLoaders);
        this.isAbsoluteFilePath = isAbsoluteFilePath;
    }

    protected Map<String, R> load0(Path path) throws ResourceLoadingException {
        String baseLocation = SECURITY_CONFIG.getBaseLocation();
        BaseConfig baseConfig = (BaseConfig)new BaseConfigJsonParser(baseLocation, this.isAbsoluteFilePath).parse();
        String version = baseConfig.getVersion();
        this.log(version, "Loading resources versioned [%s]");
        try {
            Map results = super.load0(path);
            this.log(version, "Succeeded to Load resources versioned [%s]");
            return results;
        }
        catch (ResourceLoadingException ex) {
            this.log(version, "Failed to Load resources versioned [%s]");
            throw ex;
        }
    }

    private void log(String version, String format) {
        if (version != null) {
            String msg = String.format(format, version);
            SIMPLE_LOGGER.info(msg, new Object[0]);
            this.logger.info(msg);
        }
    }
}

