/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.mask.model.guest;

import com.alibaba.security.mask.DataType;
import com.alibaba.security.mask.model.guest.AbstractGuestMaskModel;
import com.alibaba.security.util.SensitiveDataUtil;

public class PhoneGuestMaskModel
extends AbstractGuestMaskModel {
    @Override
    public DataType getDataType() {
        return DataType.Phone;
    }

    @Override
    public String doMask(String input) {
        if (input.length() <= 3) {
            return "";
        }
        if (input.contains("-")) {
            String[] split = input.split("-");
            StringBuilder sb = new StringBuilder();
            sb.append(split[0]);
            sb.append("-");
            sb.append(SensitiveDataUtil.customizeIntraMark(split[1], 0, 2));
            return sb.toString();
        }
        return SensitiveDataUtil.customizeIntraMark(input, 0, 2);
    }

    @Override
    protected boolean isValidationSupported() {
        return true;
    }

    @Override
    public boolean validate(String input) {
        return SensitiveDataUtil.isPhoneOrTelNo(input);
    }
}

