/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.mask.model.guest;

import com.alibaba.security.mask.DataType;
import com.alibaba.security.mask.division.AdministrativeDivision;
import com.alibaba.security.mask.division.AreaNormalizer;
import com.alibaba.security.mask.division.CainiaoAreaNormalizerFactory;
import com.alibaba.security.mask.division.SimpleAreaNormalizer;
import com.alibaba.security.mask.model.guest.AbstractGuestMaskModel;
import com.alibaba.security.util.ClassUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddressGuestMaskModel
extends AbstractGuestMaskModel {
    private static final String NET_HOOKS_PROVIDER_CLASS_PATH = "com.alibaba.securitysdk.division.CainiaoAreaNormalizer";
    private static final AreaNormalizer NORMALIZER;
    private static final Logger LOGGER;

    @Override
    public String doMask(String input) {
        AdministrativeDivision division = NORMALIZER.normalize(input);
        return division.normalizedDivision();
    }

    @Override
    public DataType getDataType() {
        return DataType.Address;
    }

    static {
        LOGGER = Logger.getLogger(AddressGuestMaskModel.class.getName());
        if (ClassUtils.isPresent(NET_HOOKS_PROVIDER_CLASS_PATH, ClassUtils.getDefaultClassLoader())) {
            NORMALIZER = CainiaoAreaNormalizerFactory.createAreaNormalizer();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("com.alibaba.securitysdk.division.CainiaoAreaNormalizer is not present. SimpleAreaNormalizer will be used by default.");
            }
        } else {
            NORMALIZER = new SimpleAreaNormalizer();
        }
    }
}

