/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.cli;

import com.alibaba.security.cli.CLIFilter;
import com.alibaba.security.util.CharMasks;

public class CLIFilterImpl
implements CLIFilter {
    private static final String Escape_Shell_Arg_Format = "'%s'";
    private static final int SIZE = 128;
    private static final CharMasks MASKS = new CharMasks(128){
        {
            this.addCharToMasks("#&;`|*?~<>^()[]{}$\\'\"");
            this.addCharToMasks('\n');
        }
    };
    private static final boolean[] ESCAPE_CMD_MASKS = MASKS.getMasks();

    public String escapeShellArg(String arg) {
        return CLIFilterImpl.escapeShellArgStatically(arg);
    }

    public String escapeShellCmd(String cmd) {
        return CLIFilterImpl.escapeShellCmdStatically(cmd);
    }

    public String filter(String input) {
        return CLIFilterImpl.filterStatically(input);
    }

    public static String escapeShellArgStatically(String arg) {
        if (arg == null || arg.isEmpty()) {
            return arg;
        }
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) != '\'') continue;
            sb.append(arg.substring(lastPos, i)).append('\\');
            lastPos = i;
        }
        sb.append(arg.substring(lastPos));
        return String.format(Escape_Shell_Arg_Format, sb.toString());
    }

    public static String escapeShellCmdStatically(String cmd) {
        if (cmd == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        for (int i = 0; i < cmd.length(); ++i) {
            char c = cmd.charAt(i);
            if ((c < '\u0000' || c >= '\u0080' || !ESCAPE_CMD_MASKS[c]) && c != '\u00ff') continue;
            sb.append(cmd.substring(lastPos, i));
            lastPos = i + 1;
        }
        sb.append(cmd.substring(lastPos));
        return sb.toString();
    }

    public static String filterStatically(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (CLIFilterImpl.isValidChar(c)) continue;
            char lastChar = input.charAt(lastPos);
            if (lastPos == i - 1 && !CLIFilterImpl.isValidChar(lastChar)) continue;
            sb.append(input.substring(lastPos, i));
            lastPos = i + 1;
        }
        sb.append(input.substring(lastPos, input.length()));
        return sb.toString();
    }

    static boolean isValidChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_';
    }
}

