/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.utils;

import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringUtils.class);
    private static final String NVL_VALUE = "nvl";

    public static boolean isAllAlphabetUpperCase(String string) {
        char[] chars;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        for (char c : chars = string.toCharArray()) {
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllAlphabetLowerCase(String string) {
        char[] chars;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        for (char c : chars = string.toCharArray()) {
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static String toHttps(String url) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)url) && org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"http:")) {
            return org.apache.commons.lang3.StringUtils.replace((String)url, (String)"http:", (String)"https:");
        }
        return url;
    }

    public static String format(String template, Object ... info) {
        try {
            return MessageFormat.format(template, info);
        }
        catch (Exception e) {
            LOGGER.warn("format string: {}, info: {}, error: {}", new Object[]{template, info, e.getMessage()});
            return template;
        }
    }

    public static String escapeRegexChars(String str) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return str.replace("\\", "\\\\").replace("$", "\\$").replace("{", "\\{").replace("}", "\\}").replace("[", "\\[").replace("]", "\\]").replace("|", "\\|").replace("(", "\\(").replace(")", "\\)").replace(",", "\\,").replace("^", "\\^");
    }

    public static String toValidName(String name) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        return name.replaceAll(":", "_").replaceAll("-", "_").replaceAll("\\*", "_").replaceAll("\\\\", "_").replaceAll("\\+", "_").replaceAll("%", "_").replaceAll("/", "_").replaceAll("=", "_").replaceAll("&", "_").replaceAll("#", "_").replaceAll("@", "_").replaceAll("!", "_").replaceAll("~", "_").replaceAll("`", "_").replaceAll("\\$", "_").replaceAll("\\^", "_").replaceAll("\\[", "__").replaceAll("]", "__").replaceAll("\\{", "__").replaceAll("}", "__").replaceAll("\\(", "__").replaceAll("\\)", "__");
    }

    public static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }

    public static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    public static String replaceControlCharacterPrintable(String rawString) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rawString)) {
            return rawString;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char ch : rawString.toCharArray()) {
            if (Character.isISOControl(ch)) {
                stringBuilder.append(StringEscapeUtils.escapeJava((String)(ch + "")));
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    public static boolean isNvlValue(String value) {
        return org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)NVL_VALUE);
    }
}

