/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.utils;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFunctionUtils {
    private static final Logger log = LoggerFactory.getLogger(JavaFunctionUtils.class);

    public static <T> Predicate<? super T> withExceptionIgnored(Predicate<? super T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Throwable e) {
                log.warn("ignored exception: ", e);
                return false;
            }
        };
    }

    public static <T> Consumer<T> withResultAndExceptionIgnored(Consumer<T> function) {
        return t -> {
            try {
                function.accept(t);
            }
            catch (Throwable e) {
                log.warn("ignored exception: ", e);
            }
        };
    }
}

