/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.utils;

import com.aliyun.dataworks.common.spec.domain.dw.types.ModelTreeRoot;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.nodemarket.AppConfigPack;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.nodemarket.BusinessFolder;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.nodemarket.BusinessFolderConfig;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeBizInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeFolder;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeFolderItemType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.v2.IdeFolderSubType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.FolderType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderUtils {
    private static final Logger log = LoggerFactory.getLogger(FolderUtils.class);
    private static final Map<String, String> folderItemEngineType = new HashMap<String, String>();

    public static boolean isFolderRootItemPath(String folderItemPath) {
        for (ModelTreeRoot root : ModelTreeRoot.values()) {
            if (!root.getRootKey().equalsIgnoreCase(folderItemPath)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFolderRootName(String name) {
        for (ModelTreeRoot root : ModelTreeRoot.values()) {
            if (!root.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFolderRootEnglishName(String englishName) {
        for (ModelTreeRoot root : ModelTreeRoot.values()) {
            if (!root.getEnglishName().equalsIgnoreCase(englishName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFolderRoot(String name) {
        return FolderUtils.isFolderRootEnglishName(name) || FolderUtils.isFolderRootItemPath(name) || FolderUtils.isFolderRootName(name);
    }

    public static List<IdeFolder> getBasicV3Folders(IdeBizInfo ideBizInfo) {
        List<String> folderItemNames = Arrays.asList("folderGeneral", "folderDi", "folderService", "folderAlgm", "folderUserDefined");
        IdeFolder bizFolder = new IdeFolder();
        bizFolder.setBizId(ideBizInfo.getBizName());
        bizFolder.setVersion(ideBizInfo.getVersion());
        bizFolder.setType(FolderType.BUSINESS.getCode());
        bizFolder.setSubType(IdeFolderSubType.NORMAL.getCode());
        bizFolder.setSourceApp("ide");
        bizFolder.setBizUseType(ideBizInfo.getUseType());
        bizFolder.setFolderItemName(bizFolder.getBizId());
        bizFolder.setFolderItemType(IdeFolderItemType.CODE.getCode());
        bizFolder.setFolderItemPath(Joiner.on((String)File.separator).join((Object)(Integer.valueOf(NodeUseType.SCHEDULED.getValue()).equals(ideBizInfo.getUseType()) ? ModelTreeRoot.BIZ_ROOT.getRootKey() : ModelTreeRoot.MANUAL_BIZ_ROOT.getRootKey()), (Object)ideBizInfo.getBizName(), new Object[0]));
        List<IdeFolder> list = folderItemNames.stream().map(folderItemName -> {
            IdeFolder ideFolder = new IdeFolder();
            ideFolder.setFolderItemType(IdeFolderItemType.CODE.getCode());
            ideFolder.setFolderItemName((String)folderItemName);
            ideFolder.setFolderItemPath(Joiner.on((String)File.separator).join((Object)ModelTreeRoot.BIZ_ROOT.getRootKey(), (Object)ideBizInfo.getBizName(), new Object[]{folderItemName}));
            ideFolder.setBizId(ideBizInfo.getBizName());
            ideFolder.setBizUseType(ideBizInfo.getUseType());
            ideFolder.setType(FolderType.ENGINE_TYPE.getCode());
            ideFolder.setSubType(IdeFolderSubType.NORMAL.getCode());
            ideFolder.setSourceApp("ide");
            ideFolder.setVersion(ideBizInfo.getVersion());
            ideFolder.setEngineType(folderItemEngineType.get(folderItemName));
            ideFolder.setLabelFlags(GsonUtils.toJsonString(new ArrayList()));
            return ideFolder;
        }).collect(Collectors.toList());
        list.add(bizFolder);
        return list;
    }

    public static String getEngineType(String folderItemPath) {
        String[] parts;
        if (StringUtils.isBlank((CharSequence)folderItemPath)) {
            return null;
        }
        for (String part : parts = folderItemPath.split("/")) {
            if (!folderItemEngineType.containsKey(part)) continue;
            return folderItemEngineType.get(part);
        }
        return null;
    }

    public static boolean isEngineFolder(String folderItemName) {
        return folderItemEngineType.keySet().contains(folderItemName);
    }

    public static ModelTreeRoot getModelTreeRoot(Workflow workflow) {
        if ("OLD_VERSION_WORKFLOW".equalsIgnoreCase(workflow.getName())) {
            return ModelTreeRoot.WORK_FLOW_ROOT_NEW;
        }
        return BooleanUtils.isTrue((Boolean)workflow.getScheduled()) ? ModelTreeRoot.BIZ_ROOT : ModelTreeRoot.MANUAL_BIZ_ROOT;
    }

    public static ModelTreeRoot getModelTreeRoot(String folder) {
        if (StringUtils.isBlank((CharSequence)folder)) {
            return null;
        }
        String[] parts = StringUtils.split((String)folder, (String)"/");
        return Arrays.stream(parts).map(ModelTreeRoot::searchModelTreeRoot).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean isTheSameFolder(String folderA, String folderB) {
        if (StringUtils.isBlank((CharSequence)folderA) || StringUtils.isBlank((CharSequence)folderB)) {
            return false;
        }
        ModelTreeRoot rootA = FolderUtils.getModelTreeRoot(folderA);
        ModelTreeRoot rootB = FolderUtils.getModelTreeRoot(folderB);
        if (rootA == null || rootB == null) {
            return false;
        }
        if (!Objects.equals(rootA, rootB)) {
            return false;
        }
        folderA = RegExUtils.replaceFirst((String)folderA, (String)"^/", (String)"");
        folderA = RegExUtils.replaceFirst((String)folderA, (String)"/$", (String)"");
        folderA = RegExUtils.replaceFirst((String)folderA, (String)("^" + rootA.getRootKey()), (String)"");
        folderA = RegExUtils.replaceFirst((String)folderA, (String)("^" + rootA.getName()), (String)"");
        folderA = RegExUtils.replaceFirst((String)folderA, (String)("^" + rootA.getEnglishName()), (String)"");
        folderA = RegExUtils.replaceFirst((String)folderA, (String)("^" + rootA.getModule()), (String)"");
        folderB = RegExUtils.replaceFirst((String)folderB, (String)"^/", (String)"");
        folderB = RegExUtils.replaceFirst((String)folderB, (String)"/$", (String)"");
        folderB = RegExUtils.replaceFirst((String)folderB, (String)("^" + rootB.getRootKey()), (String)"");
        folderB = RegExUtils.replaceFirst((String)folderB, (String)("^" + rootB.getName()), (String)"");
        folderB = RegExUtils.replaceFirst((String)folderB, (String)("^" + rootB.getEnglishName()), (String)"");
        folderB = RegExUtils.replaceFirst((String)folderB, (String)("^" + rootB.getModule()), (String)"");
        return StringUtils.equals((CharSequence)folderA, (CharSequence)folderB);
    }

    public static String normalizeFolder(String folder) {
        if (StringUtils.isBlank((CharSequence)folder)) {
            return folder;
        }
        ModelTreeRoot root = FolderUtils.getModelTreeRoot(folder);
        if (root == null) {
            return folder;
        }
        folder = RegExUtils.replaceFirst((String)folder, (String)"^/", (String)"");
        if (StringUtils.startsWith((CharSequence)(folder = RegExUtils.replaceFirst((String)folder, (String)"/$", (String)"")), (CharSequence)root.getRootKey())) {
            folder = RegExUtils.replaceFirst((String)folder, (String)("^" + root.getRootKey()), (String)root.getEnglishName());
        } else if (StringUtils.startsWith((CharSequence)folder, (CharSequence)root.getName())) {
            folder = RegExUtils.replaceFirst((String)folder, (String)("^" + root.getName()), (String)root.getEnglishName());
        }
        return Arrays.stream(StringUtils.split((String)folder, (String)"/")).map(StringUtils::trimToEmpty).filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
    }

    public static boolean isUnderFolder(String childFolder, String parentFolder) {
        childFolder = FolderUtils.normalizeFolder(childFolder);
        parentFolder = FolderUtils.normalizeFolder(parentFolder);
        List<String> childPaths = Arrays.asList(StringUtils.split((String)((String)StringUtils.defaultIfBlank((CharSequence)childFolder, (CharSequence)"")), (String)"/"));
        List<String> parentPaths = Arrays.asList(StringUtils.split((String)((String)StringUtils.defaultIfBlank((CharSequence)parentFolder, (CharSequence)"")), (String)"/"));
        if (CollectionUtils.size(parentPaths) >= CollectionUtils.size(childPaths)) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < CollectionUtils.size(parentPaths); ++i) {
            if (StringUtils.equals((CharSequence)childPaths.get(i), (CharSequence)parentPaths.get(i))) continue;
            match = false;
            break;
        }
        return match;
    }

    public static String normalizeConfigPackPathToSpec(Integer nodeTypeId, String folderPath, Map<String, AppConfigPack> configPack, Locale locale) {
        if (StringUtils.isBlank((CharSequence)folderPath) || nodeTypeId == null || configPack == null || locale == null) {
            log.warn("invalid input parameters, folderPath: {}, nodeTypeId: {},  locale: {}", new Object[]{folderPath, nodeTypeId, locale});
            return folderPath;
        }
        ArrayList<String> path = new ArrayList<String>(Arrays.asList(StringUtils.split((String)folderPath, (String)File.separator)));
        List<String> relativePath = FolderUtils.addFolderLabels(nodeTypeId, path, configPack, locale);
        return Joiner.on((String)"/").join(relativePath);
    }

    private static List<String> addFolderLabels(Integer nodeTypeId, List<String> paths, Map<String, AppConfigPack> configPack, Locale locale) {
        if (CollectionUtils.isEmpty(paths)) {
            return paths;
        }
        String modelRoot = paths.get(0);
        Arrays.stream(ModelTreeRoot.values()).filter(v -> v.matches(modelRoot)).findAny().ifPresent(root -> paths.set(0, root.getDisplayName(locale)));
        if (CollectionUtils.size(paths) >= 3) {
            String engineFolderName = paths.get(2);
            Optional.ofNullable(configPack).map(Map::values).flatMap(values -> values.stream().map(AppConfigPack::getConfigValue).map(value -> (BusinessFolderConfig)GsonUtils.fromJsonString((String)value, BusinessFolderConfig.class)).filter(Objects::nonNull).filter(conf -> {
                boolean displayNameMatches = MapUtils.emptyIfNull(conf.getDisplayName()).values().stream().anyMatch(displayName -> StringUtils.equalsIgnoreCase((CharSequence)engineFolderName, (CharSequence)displayName));
                boolean folderMatches = Optional.ofNullable(conf.getFolders()).map(BusinessFolder::getName).map(folderName -> StringUtils.equalsIgnoreCase((CharSequence)folderName, (CharSequence)engineFolderName)).orElse(false);
                return displayNameMatches || folderMatches;
            }).findAny()).ifPresent(businessFolderConfig -> {
                if (CollectionUtils.size((Object)paths) >= 3) {
                    AtomicInteger indexAt = new AtomicInteger(3);
                    AtomicBoolean replace = new AtomicBoolean(false);
                    BusinessFolder folderConf = Optional.ofNullable(businessFolderConfig.getFolders()).map(BusinessFolder::getChildrens).orElse(ListUtils.emptyIfNull(null)).stream().map(label -> ListUtils.emptyIfNull(label.getChildrens()).stream().filter(lc -> ListUtils.emptyIfNull(lc.getNodes()).stream().anyMatch(node -> Objects.equals(node.getId(), nodeTypeId))).findAny()).findAny().flatMap(label -> label).orElseGet(() -> {
                        BusinessFolder r = Optional.ofNullable(businessFolderConfig.getFolders()).filter(folder -> ListUtils.emptyIfNull(folder.getNodes()).stream().anyMatch(node -> Objects.equals(node.getId(), nodeTypeId))).orElse(null);
                        indexAt.set(2);
                        replace.set(true);
                        return r;
                    });
                    if (folderConf != null) {
                        MapUtils.emptyIfNull(folderConf.getDisplayName()).entrySet().stream().filter(ent -> StringUtils.containsIgnoreCase((CharSequence)locale.toString(), (CharSequence)((CharSequence)ent.getKey()))).map(Map.Entry::getValue).findAny().ifPresent(label -> {
                            if (replace.get()) {
                                paths.set(indexAt.get(), (String)label);
                            } else {
                                paths.add(indexAt.get(), (String)label);
                            }
                        });
                    }
                    MapUtils.emptyIfNull(businessFolderConfig.getDisplayName()).entrySet().stream().filter(ent -> StringUtils.containsIgnoreCase((CharSequence)locale.toString(), (CharSequence)((CharSequence)ent.getKey()))).map(Map.Entry::getValue).findAny().ifPresent(label -> paths.set(2, (String)label));
                }
            });
        }
        return paths;
    }

    public static String normalizeSpecPathToConfigPack(String folderPath, Map<String, AppConfigPack> configPack) {
        List<String> path = Arrays.asList(StringUtils.split((String)folderPath, (String)File.separator));
        String modelTreeRootDir = path.stream().filter(p -> ModelTreeRoot.searchModelTreeRoot((String)p) != null).findFirst().orElseThrow(() -> new RuntimeException("model tree root not found at path: " + folderPath));
        int modelTreeRootDirIdx = path.indexOf(modelTreeRootDir);
        List<String> relativePath = FolderUtils.removeFolderLabels(new ArrayList<String>(path.subList(modelTreeRootDirIdx, path.size() - 1)), configPack);
        return Joiner.on((String)"/").join(relativePath);
    }

    private static List<String> removeFolderLabels(List<String> paths, Map<String, AppConfigPack> configPack) {
        if (CollectionUtils.size(paths) >= 3) {
            String engineFolderName = paths.get(2);
            Boolean isEngineFolder = Optional.ofNullable(configPack).map(Map::values).map(values -> values.stream().map(AppConfigPack::getConfigValue).map(value -> (BusinessFolderConfig)GsonUtils.fromJsonString((String)value, BusinessFolderConfig.class)).filter(Objects::nonNull).anyMatch(conf -> MapUtils.emptyIfNull(conf.getDisplayName()).values().stream().anyMatch(displayName -> StringUtils.equalsIgnoreCase((CharSequence)engineFolderName, (CharSequence)displayName)))).orElse(false);
            if (isEngineFolder.booleanValue() && CollectionUtils.size(paths) > 3) {
                paths.remove(3);
            }
        }
        return paths;
    }

    static {
        folderItemEngineType.put("folderFlink", "Flink");
        folderItemEngineType.put("folderGeneral", "General");
        folderItemEngineType.put("folderDi", "Data Integration");
        folderItemEngineType.put("folderUserDefined", "UserDefined");
        folderItemEngineType.put("folderEMR", "EMR");
        folderItemEngineType.put("folderMaxCompute", "MaxCompute");
        folderItemEngineType.put("folderAlgm", "Algorithm");
        folderItemEngineType.put("folderService", "DataService");
        folderItemEngineType.put("folderADB", "ADB");
        folderItemEngineType.put("folderHologres", "Hologres");
        folderItemEngineType.put("folderADBMysql", "ADBMYSQL");
        folderItemEngineType.put("folderMorse", "Morse");
        folderItemEngineType.put("folderJdbc", "Jdbc");
    }
}

