/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.utils;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeConstants;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class DataStudioCodeUtils {
    public static String addResourceReference(CodeProgramType type, String code, Collection<String> resources) {
        if (type == null) {
            return code;
        }
        switch (type) {
            case SQL_COMPONENT: 
            case ODPS_SQL: 
            case EMR_SPARK_SQL: 
            case CLICK_SQL: 
            case EMR_HIVE: 
            case EMR_IMPALA: 
            case EMR_PRESTO: 
            case CDH_SPARK_SQL: 
            case CDH_IMPALA: 
            case CDH_PRESTO: {
                return DataStudioCodeUtils.addSqlResourceReference(code, resources);
            }
        }
        return DataStudioCodeUtils.addShellResourceReference(code, resources);
    }

    private static String addSqlResourceReference(String code, Collection<String> resources) {
        if (CollectionUtils.isEmpty(resources)) {
            return code;
        }
        String references = Joiner.on((String)"\n").join((Iterable)resources.stream().map(str -> "--@resource_reference{\"" + str + "\"}").collect(Collectors.toList()));
        return Joiner.on((char)'\n').join((Object)references, (Object)code, new Object[0]);
    }

    private static String addShellResourceReference(String code, Collection<String> resources) {
        if (CollectionUtils.isEmpty(resources)) {
            return code;
        }
        String references = Joiner.on((String)"\n").join((Iterable)resources.stream().filter(Objects::nonNull).map(str -> "##@resource_reference{\"" + str + "\"}").collect(Collectors.toList()));
        return Joiner.on((char)'\n').join((Object)references, (Object)code, new Object[0]);
    }

    public static List<String> parseResourceReference(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return ListUtils.emptyIfNull(null);
        }
        Matcher m = CodeConstants.RESOURCE_REFERENCE_PATTERN.matcher(code);
        ArrayList<String> resources = new ArrayList<String>();
        while (m.find()) {
            resources.add(m.group("resourceName"));
        }
        return resources;
    }
}

