/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.component.SpecComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.BasicNodeSpecHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentSqlNodeSpecHandler
extends BasicNodeSpecHandler {
    private static final Logger log = LoggerFactory.getLogger(ComponentSqlNodeSpecHandler.class);

    @Override
    public boolean support(DwNodeEntity dwNode) {
        return this.matchNodeType(dwNode, CodeProgramType.COMPONENT_SQL);
    }

    @Override
    public SpecNode handle(DwNodeEntity dmNode) {
        SpecNode node = super.handle(dmNode);
        Optional.ofNullable(dmNode.getComponent()).ifPresent(com -> {
            SpecComponent specCom = new SpecComponent();
            specCom.setId(com.getId());
            specCom.setName(com.getName());
            specCom.setOwner(com.getOwner());
            specCom.setDescription(com.getDescription());
            specCom.setInputs(com.getInputs());
            specCom.setOutputs(com.getOutputs());
            specCom.setMetadata(com.getMetadata());
            node.setComponent(specCom);
        });
        return node;
    }
}

