/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler;

import com.aliyun.dataworks.common.spec.adapter.SpecHandlerContext;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecSubFlow;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.BasicNodeSpecHandler;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedNodeSpecHandler
extends BasicNodeSpecHandler {
    private static final Logger log = LoggerFactory.getLogger(CombinedNodeSpecHandler.class);

    @Override
    public boolean support(DwNodeEntity dwNode) {
        return this.matchNodeType(dwNode, CodeProgramType.COMBINED_NODE);
    }

    @Override
    public SpecNode handle(DwNodeEntity orcNode) {
        Preconditions.checkNotNull((Object)orcNode, (Object)"node is null");
        SpecNode specNode = super.handle(orcNode);
        if (this.support(orcNode)) {
            List<DwNodeEntity> innerNodes = this.getInnerNodes(orcNode);
            specNode.setCombined(this.buildCombined(orcNode, specNode, innerNodes, this.context));
        }
        return specNode;
    }

    public SpecNode handle(DwNodeEntity parentNode, List<DwNodeEntity> innerNodes) {
        Preconditions.checkNotNull((Object)parentNode, (Object)"node is null");
        SpecNode specNode = super.handle(parentNode);
        if (this.support(parentNode)) {
            specNode.setCombined(this.buildCombined(parentNode, specNode, innerNodes, this.context));
        }
        return specNode;
    }

    private SpecSubFlow buildCombined(DwNodeEntity orcNode, SpecNode specNode, List<DwNodeEntity> innerNodes, SpecHandlerContext context) {
        SpecSubFlow combined = new SpecSubFlow();
        combined.setNodes(innerNodes.stream().map(n -> (SpecNode)this.getSpecAdapter().getHandler(n, context.getLocale()).handle(n)).collect(Collectors.toList()));
        combined.setDependencies(innerNodes.stream().map(node -> this.getSpecAdapter().toFlow(this, (DwNodeEntity)node, context)).flatMap(Collection::stream).collect(Collectors.toList()));
        return combined;
    }
}

