/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModel;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModelFactory;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerBranchCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecBranch;
import com.aliyun.dataworks.common.spec.domain.noref.SpecBranches;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.handler.BasicNodeSpecHandler;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchNodeSpecHandler
extends BasicNodeSpecHandler {
    private static final Logger log = LoggerFactory.getLogger(BranchNodeSpecHandler.class);

    @Override
    public boolean support(DwNodeEntity node) {
        return this.matchNodeType(node, CodeProgramType.CONTROLLER_BRANCH);
    }

    @Override
    public SpecNode handle(DwNodeEntity orcNode) {
        SpecNode specNode = super.handle(orcNode);
        specNode.setBranch(this.buildBranch(orcNode));
        return specNode;
    }

    private SpecBranch buildBranch(DwNodeEntity orcNode) {
        SpecBranch specBranch = new SpecBranch();
        CodeModel codeModel = CodeModelFactory.getCodeModel((String)CodeProgramType.CONTROLLER_BRANCH.name(), (String)orcNode.getCode());
        List branches = ListUtils.emptyIfNull((List)Optional.ofNullable((ControllerBranchCode)codeModel.getCodeModel()).map(ControllerBranchCode::getBranchList).orElse(null));
        specBranch.setBranches(ListUtils.emptyIfNull((List)branches).stream().map(branch -> {
            SpecBranches b = new SpecBranches();
            b.setDesc(branch.getDescription());
            SpecNodeOutput output = new SpecNodeOutput();
            output.setData(branch.getNodeoutput());
            b.setOutput(output);
            b.setWhen(branch.getCondition());
            return b;
        }).collect(Collectors.toList()));
        return specBranch;
    }
}

