/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity;

import com.alibaba.fastjson2.JSON;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModel;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModelFactory;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ComponentSqlCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.SqlComponentCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.component.SpecComponent;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeContext;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.RerunMode;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.spec.entity.DwNodeEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwNodeEntityAdapter
implements DwNodeEntity {
    private static final Logger log = LoggerFactory.getLogger(DwNodeEntityAdapter.class);
    private final DwNode dwNode;
    private DwNode dwParentNode;

    public DwNodeEntityAdapter(DwNode dwNode) {
        this.dwNode = dwNode;
    }

    public DwNodeEntityAdapter(DwNode dwNode, DwNode dwParentNode) {
        this.dwNode = dwNode;
        this.dwParentNode = dwParentNode;
    }

    @Override
    public String getUuid() {
        return this.dwNode.getGlobalUuid();
    }

    @Override
    public Long getBizId() {
        return null;
    }

    @Override
    public String getBizName() {
        return null;
    }

    @Override
    public String getResourceGroupName() {
        return this.dwNode.getResourceGroupName();
    }

    @Override
    public Long getResourceGroupId() {
        return null;
    }

    @Override
    public String getName() {
        return this.dwNode.getName();
    }

    @Override
    public String getType() {
        return this.dwNode.getType();
    }

    @Override
    public Integer getTypeId() {
        return Optional.ofNullable(CodeProgramType.getNodeTypeByName((String)this.getType())).map(CodeProgramType::getCode).orElse(null);
    }

    @Override
    public String getCronExpress() {
        return this.dwNode.getCronExpress();
    }

    @Override
    public Date getStartEffectDate() {
        return this.dwNode.getStartEffectDate();
    }

    @Override
    public Integer getIsAutoParse() {
        return this.dwNode.getIsAutoParse();
    }

    @Override
    public Date getEndEffectDate() {
        return this.dwNode.getEndEffectDate();
    }

    @Override
    public String getResourceGroup() {
        return this.dwNode.getResourceGroup();
    }

    @Override
    public String getDiResourceGroup() {
        return this.dwNode.getDiResourceGroup();
    }

    @Override
    public String getDiResourceGroupName() {
        return this.dwNode.getDiResourceGroupName();
    }

    @Override
    public String getCodeMode() {
        return this.dwNode.getCodeMode();
    }

    @Override
    public Boolean getStartRightNow() {
        return this.dwNode.getStartRightNow();
    }

    @Override
    public RerunMode getRerunMode() {
        return this.dwNode.getRerunMode();
    }

    @Override
    public Integer getNodeType() {
        return null;
    }

    @Override
    public Boolean getPauseSchedule() {
        return this.dwNode.getPauseSchedule();
    }

    @Override
    public NodeUseType getNodeUseType() {
        return this.dwNode.getNodeUseType();
    }

    @Override
    public String getRef() {
        return this.dwNode.getRef();
    }

    @Override
    public String getFolder() {
        return this.dwNode.getFolder();
    }

    @Override
    public Boolean getRoot() {
        return this.dwNode.getRoot();
    }

    @Override
    public String getConnection() {
        return this.dwNode.getConnection();
    }

    @Override
    public String getCode() {
        return this.dwNode.getCode();
    }

    @Override
    public String getParameter() {
        return this.dwNode.getParameter();
    }

    @Override
    public List<NodeContext> getInputContexts() {
        return this.dwNode.getInputContexts();
    }

    @Override
    public List<NodeContext> getOutputContexts() {
        return this.dwNode.getOutputContexts();
    }

    @Override
    public List<NodeIo> getInputs() {
        return this.dwNode.getInputs();
    }

    @Override
    public List<NodeIo> getOutputs() {
        return this.dwNode.getOutputs();
    }

    @Override
    public List<DwNodeEntity> getInnerNodes() {
        return ListUtils.emptyIfNull(this.dwNode.getInnerNodes()).stream().map(n -> new DwNodeEntityAdapter((DwNode)n)).collect(Collectors.toList());
    }

    @Override
    public String getDescription() {
        return this.dwNode.getDescription();
    }

    @Override
    public Integer getTaskRerunTime() {
        return this.dwNode.getTaskRerunTime();
    }

    @Override
    public Integer getTaskRerunInterval() {
        return this.dwNode.getTaskRerunInterval();
    }

    @Override
    public Integer getDependentType() {
        return this.dwNode.getDependentType();
    }

    @Override
    public Integer getCycleType() {
        return this.dwNode.getCycleType();
    }

    @Override
    public Date getLastModifyTime() {
        return this.dwNode.getLastModifyTime();
    }

    @Override
    public String getLastModifyUser() {
        return this.dwNode.getLastModifyUser();
    }

    @Override
    public Integer getMultiInstCheckType() {
        return this.dwNode.getMultiInstCheckType();
    }

    @Override
    public Integer getPriority() {
        return this.dwNode.getPriority();
    }

    @Override
    public String getDependentDataNode() {
        return this.dwNode.getDependentDataNode();
    }

    @Override
    public String getOwner() {
        return this.dwNode.getOwner();
    }

    @Override
    public String getOwnerName() {
        return this.dwNode.getOwnerName();
    }

    @Override
    public String getExtraConfig() {
        return this.dwNode.getExtraConfig();
    }

    @Override
    public String getExtraContent() {
        return this.dwNode.getExtraContent();
    }

    @Override
    public String getTtContent() {
        return this.dwNode.getTtContent();
    }

    @Override
    public String getAdvanceSettings() {
        return this.dwNode.getAdvanceSettings();
    }

    @Override
    public String getExtend() {
        return this.dwNode.getExtend();
    }

    @Override
    public SpecComponent getComponent() {
        return Optional.ofNullable(CodeProgramType.getNodeTypeByName((String)this.getType())).map(type -> {
            if (CodeProgramType.COMPONENT_SQL.name().equalsIgnoreCase(type.name())) {
                return this.getComponentSql();
            }
            return this.getSqlComponent();
        }).orElse(null);
    }

    @Override
    public String getImageId() {
        return this.dwNode.getImageId();
    }

    @Override
    public Long getCalendarId() {
        return this.dwNode.getCalendarId();
    }

    @Override
    public Integer getStreamLaunchMode() {
        return null;
    }

    @Override
    public Boolean getIgnoreBranchConditionSkip() {
        try {
            return Optional.ofNullable(this.dwNode.getExtraConfig()).filter(StringUtils::isNotBlank).map(JSON::parseObject).map(js -> js.getBoolean("ignoreBranchConditionSkip")).orElse(null);
        }
        catch (Exception e) {
            log.warn("ignoreBranchConditionSkip parse error, text: {}", (Object)this.getExtraConfig(), (Object)e);
            return null;
        }
    }

    @Override
    public Integer getAlisaTaskKillTimeout() {
        try {
            return Optional.ofNullable(this.getExtraConfig()).filter(StringUtils::isNotBlank).map(JSON::parseObject).map(extConfig -> extConfig.getInteger("alisaTaskKillTimeout")).orElse(null);
        }
        catch (Exception e) {
            log.warn("parse extConfig.alisaTaskKillTimeout failed: {}, ", (Object)this.getExtraConfig(), (Object)e);
            return null;
        }
    }

    @Override
    public Integer getLoopCount() {
        try {
            return Optional.ofNullable(this.getExtraConfig()).filter(StringUtils::isNotBlank).map(JSON::parseObject).map(extConfig -> extConfig.getInteger("loopCount")).orElse(null);
        }
        catch (Exception e) {
            log.warn("parse extConfig.loopCount failed: {}, ", (Object)this.getExtraConfig(), (Object)e);
            return null;
        }
    }

    @Override
    public Long getParentId() {
        return null;
    }

    @Override
    public DwNodeEntity getParentNode() {
        return Optional.ofNullable(this.dwParentNode).map(DwNodeEntityAdapter::new).orElse(null);
    }

    @Override
    public String getCu() {
        return this.dwNode.getCu();
    }

    @Override
    public String getOrigin() {
        return this.dwNode.getOrigin();
    }

    @Override
    public String getWorkflowName() {
        return this.dwNode.getWorkflowRef() == null ? null : this.dwNode.getWorkflowRef().getName();
    }

    private SpecComponent getSqlComponent() {
        CodeModel codeModel = CodeModelFactory.getCodeModel((String)CodeProgramType.SQL_COMPONENT.name(), (String)this.getCode());
        SpecComponent com = Optional.ofNullable((SqlComponentCode)codeModel.getCodeModel()).map(SqlComponentCode::getConfig).orElse(new SpecComponent());
        com.setId(this.getUuid());
        com.setName(this.getName());
        com.setOwner(this.getOwner());
        com.setDescription(this.getDescription());
        com.setInputs(com.getInputs());
        com.setOutputs(com.getOutputs());
        SpecScript script = new SpecScript();
        script.setContent(((SqlComponentCode)codeModel.getCodeModel()).getCode());
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setCommand(CodeProgramType.SQL_COMPONENT.getName());
        runtime.setCommandTypeId(Integer.valueOf(CodeProgramType.SQL_COMPONENT.getCode()));
        script.setRuntime(runtime);
        com.setScript(script);
        return com;
    }

    private SpecComponent getComponentSql() {
        CodeModel codeModel = CodeModelFactory.getCodeModel((String)CodeProgramType.COMPONENT_SQL.name(), (String)this.getCode());
        SpecComponent com = Optional.ofNullable(((ComponentSqlCode)codeModel.getCodeModel()).getConfig()).orElse(new SpecComponent());
        Optional.ofNullable(((ComponentSqlCode)codeModel.getCodeModel()).getComponent()).map(ComponentSqlCode.ComponentInfo::getId).map(String::valueOf).ifPresent(arg_0 -> ((SpecComponent)com).setId(arg_0));
        Optional.ofNullable(((ComponentSqlCode)codeModel.getCodeModel()).getComponent()).map(ComponentSqlCode.ComponentInfo::getName).ifPresent(arg_0 -> ((SpecComponent)com).setName(arg_0));
        HashMap<String, String> metadata = new HashMap<String, String>();
        Optional.ofNullable((ComponentSqlCode)codeModel.getCodeModel()).map(ComponentSqlCode::getComponent).map(ComponentSqlCode.ComponentInfo::getVersion).ifPresent(version -> metadata.put("version", (String)version));
        metadata.put("id", com.getId());
        com.setMetadata(metadata);
        return com;
    }

    public DwNode getDwNode() {
        return this.dwNode;
    }

    public DwNode getDwParentNode() {
        return this.dwParentNode;
    }
}

