/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.writer.impl;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.annotation.SpecWriter;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.impl.DefaultJsonObjectWriter;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@SpecWriter
public class SpecificationWriter
extends DefaultJsonObjectWriter<Specification> {
    public SpecificationWriter(SpecWriterContext context) {
        super(context);
    }

    @Override
    public JSONObject write(Specification specObj, SpecWriterContext context) {
        if (specObj == null || context == null) {
            return null;
        }
        if (specObj.getVersion() != null) {
            context.setVersion(specObj.getVersion());
        }
        Preconditions.checkNotNull((Object)context.getVersion(), (Object)"version is null");
        Preconditions.checkNotNull((Object)specObj.getVersion(), (Object)"version is null");
        JSONObject jsonObject = this.writeJsonObject(specObj, true);
        Optional.ofNullable(specObj.getVersion()).orElseThrow(() -> new SpecException(SpecErrorCode.PARSE_ERROR, "version is null"));
        if (StringUtils.equalsIgnoreCase((CharSequence)SpecVersion.V_1_0_0.getLabel(), (CharSequence)specObj.getVersion())) {
            jsonObject.remove((Object)"spec");
            JSONObject spec = (JSONObject)this.writeByWriter(specObj.getSpec());
            if (spec != null) {
                for (String key : spec.keySet()) {
                    jsonObject.put((Object)key, spec.get(key));
                }
            }
        } else {
            jsonObject.put((Object)"spec", this.writeByWriter(specObj.getSpec()));
        }
        return jsonObject;
    }
}

