/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser.impl;

import com.aliyun.dataworks.common.spec.annotation.SpecParser;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.interfaces.NodeIO;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecArtifact;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.parser.Parser;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.utils.MapKeyMatchUtils;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@SpecParser
public class SpecNodeParser
implements Parser<SpecNode> {
    @Override
    public SpecNode parse(Map<String, Object> ctxMap, SpecParserContext specParserContext) {
        SpecNode specNode = new SpecNode();
        SpecDevUtil.setSameKeyField(ctxMap, specNode, specParserContext);
        SpecDevUtil.setSpecObject(specNode, "doWhile", ctxMap.get("do-while"), specParserContext);
        SpecDevUtil.setSpecObject(specNode, "foreach", ctxMap.get("for-each"), specParserContext);
        SpecDevUtil.setSpecObject(specNode, "paiflow", ctxMap.get("paiflow"), specParserContext);
        SpecDevUtil.setSpecObject(specNode, "paramHub", ctxMap.get("param-hub"), specParserContext);
        SpecDevUtil.setSpecObject(specNode, "subflow", ctxMap.get("subflow"), specParserContext);
        specNode.setInputs(SpecNodeParser.parseInputOutputs(specParserContext, (Map)ctxMap.get("inputs")));
        specNode.setOutputs(SpecNodeParser.parseInputOutputs(specParserContext, (Map)ctxMap.get("outputs")));
        ListUtils.emptyIfNull(specNode.getOutputs()).stream().filter(out -> out instanceof SpecVariable).map(out -> (SpecVariable)out).filter(out -> out.getNode() == null).forEach(out -> {
            SpecDepend node = new SpecDepend();
            node.setNodeId(specNode);
            SpecNodeOutput specOut = new SpecNodeOutput();
            specOut.setData(node.getNodeId().getId());
            node.setOutput(specOut);
            out.setNode(node);
        });
        return specNode;
    }

    @Override
    public String getKeyType() {
        return "node";
    }

    public static <T extends NodeIO> ArrayList<T> parseInputOutputs(SpecParserContext contextMeta, Map<String, Object> ioCtxMap) {
        ArrayList ioList = new ArrayList();
        Reflections reflections = new Reflections(SpecArtifact.class.getPackage().getName(), new Scanner[0]);
        Set artifactClzTypes = reflections.getSubTypesOf(SpecArtifact.class);
        SetUtils.emptyIfNull((Set)artifactClzTypes).forEach(artifactClzType -> {
            try {
                SpecArtifact ins = (SpecArtifact)artifactClzType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                List<Object> artifacts = SpecNodeParser.getArtifacts(ioCtxMap, ins.getArtifactType());
                for (Object artifact : artifacts) {
                    if (artifact instanceof Map) {
                        NodeIO parse = (NodeIO)SpecDevUtil.getObjectByParser(artifactClzType, artifact, contextMeta);
                        ioList.add(parse);
                        continue;
                    }
                    SpecDevUtil.setRefContext(ioList, SpecDevUtil.parseRefId((String)artifact).getId(), contextMeta, null, artifactClzType.getSimpleName());
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
        return ioList;
    }

    private static List<Object> getArtifacts(Map<String, Object> map, ArtifactType ... typeFilters) {
        List types = Arrays.stream(ArtifactType.values()).filter(type -> typeFilters == null || Arrays.asList(typeFilters).contains(type)).collect(Collectors.toList());
        return ListUtils.emptyIfNull(types).stream().map(type -> MapUtils.emptyIfNull((Map)map).entrySet().stream().filter(ent -> SpecNodeParser.matchArtifactType(type, (String)ent.getKey())).map(Map.Entry::getValue).map(v -> (List)v).flatMap(Collection::stream).peek(obj -> {
            if (obj instanceof HashMap && !((HashMap)obj).containsKey("type")) {
                ((HashMap)obj).put("type", type);
            }
        }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static boolean matchArtifactType(ArtifactType type, String key) {
        if (type == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        if (type == ArtifactType.NODE_OUTPUT) {
            return MapKeyMatchUtils.matchIgnoreSinglePluralForm(key, type.getLabel()) || MapKeyMatchUtils.matchIgnoreSinglePluralForm(key, "output");
        }
        return MapKeyMatchUtils.matchIgnoreSinglePluralForm(key, type.getLabel());
    }
}

