/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser.impl;

import com.aliyun.dataworks.common.spec.annotation.SpecParser;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecArtifact;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.parser.Parser;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.utils.MapKeyMatchUtils;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

@SpecParser
public class ArtifactListParser
implements Parser<List<SpecArtifact>> {
    public static final String KEY_TYPE = "artifactsList";

    @Override
    public List<SpecArtifact> parse(Map<String, Object> rawContext, SpecParserContext specParserContext) {
        List variables;
        List outputs;
        ArrayList<SpecArtifact> specArtifacts = new ArrayList<SpecArtifact>();
        List tables = (List)MapKeyMatchUtils.getIgnoreCaseSingleAndPluralForm(rawContext, ArtifactType.TABLE.getLabel());
        if (CollectionUtils.isNotEmpty((Collection)tables)) {
            for (Object table : tables) {
                table.put("type", ArtifactType.TABLE.getLabel());
                SpecTable specArtifact = (SpecTable)SpecDevUtil.getObjectByParser(SpecTable.class, table, specParserContext);
                SpecDevUtil.setEntityToCtx(specArtifact, specParserContext);
                specArtifacts.add(specArtifact);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(outputs = (List)MapKeyMatchUtils.getIgnoreCaseSingleAndPluralForm(rawContext, "output", ArtifactType.NODE_OUTPUT.getLabel())))) {
            for (Map output : outputs) {
                output.put("type", ArtifactType.NODE_OUTPUT.getLabel());
                SpecNodeOutput specArtifact = (SpecNodeOutput)SpecDevUtil.getObjectByParser(SpecNodeOutput.class, output, specParserContext);
                SpecDevUtil.setEntityToCtx(specArtifact, specParserContext);
                specArtifacts.add(specArtifact);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(variables = (List)MapKeyMatchUtils.getIgnoreCaseSingleAndPluralForm(rawContext, ArtifactType.VARIABLE.getLabel())))) {
            for (Map variable : variables) {
                SpecVariable specArtifact = (SpecVariable)SpecDevUtil.getObjectByParser(SpecVariable.class, variable, specParserContext);
                SpecDevUtil.setEntityToCtx(specArtifact, specParserContext);
                specArtifacts.add(specArtifact);
            }
        }
        return specArtifacts;
    }

    @Override
    public String getKeyType() {
        return KEY_TYPE;
    }
}

