/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.nodemodel;

import com.alibaba.fastjson2.JSON;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.DataWorksNode;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.DataWorksNodeAdapterContextAware;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.DataWorksNodeCodeAdapter;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.DataWorksNodeInputOutputAdapter;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.DwNodeDependentTypeInfo;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.InputContext;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.OutputContext;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.SpecEntityDelegate;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRecurrenceType;
import com.aliyun.dataworks.common.spec.domain.enums.TriggerType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Input;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDoWhile;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecForEach;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScheduleStrategy;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWorksNodeAdapter
implements DataWorksNode,
DataWorksNodeAdapterContextAware {
    public static final String TIMEOUT = "alisaTaskKillTimeout";
    public static final String IGNORE_BRANCH_CONDITION_SKIP = "ignoreBranchConditionSkip";
    public static final String LOOP_COUNT = "loopCount";
    public static final String STREAM_LAUNCH_MODE = "streamLaunchMode";
    public static final Integer NODE_TYPE_NORMAL = 0;
    public static final Integer NODE_TYPE_MANUAL = 1;
    public static final Integer NODE_TYPE_PAUSE = 2;
    public static final Integer NODE_TYPE_SKIP = 3;
    public static final Integer NODE_TYPE_NONE_AUTO = 4;
    private static final Logger logger = LoggerFactory.getLogger(DataWorksNodeAdapter.class);
    private static final String DELAY_SECONDS = "delaySeconds";
    private static final List<String> METADATA_KEYS = Lists.newArrayList((Object[])new String[]{"sourceType", "sourceResourceUuid"});
    protected final DataWorksWorkflowSpec specification;
    protected final Specification<DataWorksWorkflowSpec> spec;
    protected final SpecEntityDelegate<? extends SpecRefEntity> delegate;
    protected Context context;

    public DataWorksNodeAdapter(Specification<DataWorksWorkflowSpec> specification, SpecRefEntity specEntity) {
        this.spec = specification;
        this.specification = this.spec.getSpec();
        this.delegate = new SpecEntityDelegate<SpecRefEntity>(specEntity);
        this.context = Context.builder().build();
    }

    public DataWorksNodeAdapter(Specification<DataWorksWorkflowSpec> specification, SpecRefEntity specEntity, Context context) {
        this.spec = specification;
        this.specification = this.spec.getSpec();
        this.delegate = new SpecEntityDelegate<SpecRefEntity>(specEntity);
        this.context = context;
    }

    @Override
    public DwNodeDependentTypeInfo getDependentType(Function<List<SpecNodeOutput>, List<Long>> getNodeIdsByOutputs) {
        List<SpecFlowDepend> flows = ListUtils.emptyIfNull(this.specification.getFlow());
        SpecWorkflow outerWorkflow = Optional.ofNullable(this.spec).map(Specification::getSpec).map(DataWorksWorkflowSpec::getWorkflows).flatMap(wfs -> wfs.stream().filter(wf -> ListUtils.emptyIfNull(wf.getNodes()).stream().anyMatch(n -> StringUtils.equalsIgnoreCase((CharSequence)n.getId(), (CharSequence)this.delegate.getId()))).findFirst()).orElse(null);
        if (outerWorkflow != null) {
            flows = outerWorkflow.getDependencies();
        }
        SpecFlowDepend specNodeFlowDepend = ListUtils.emptyIfNull((List)flows).stream().filter(fd -> StringUtils.equalsIgnoreCase((CharSequence)this.delegate.getId(), (CharSequence)fd.getNodeId().getId())).peek(fd -> logger.info("node flow depends source nodeId: {}, depends: {}", (Object)JSON.toJSONString((Object)fd.getNodeId()), (Object)JSON.toJSONString(fd.getDepends()))).findFirst().orElse(null);
        return this.getDependentType(specNodeFlowDepend, getNodeIdsByOutputs);
    }

    private DwNodeDependentTypeInfo getDependentType(SpecFlowDepend specNodeFlowDepend, Function<List<SpecNodeOutput>, List<Long>> getNodeIdsByOutputs) {
        Optional<SpecDepend> self = Optional.ofNullable(specNodeFlowDepend).map(SpecFlowDepend::getDepends).orElse(ListUtils.emptyIfNull(null)).stream().filter(dep -> DependencyType.CROSS_CYCLE_SELF.equals(dep.getType())).findAny();
        Optional<SpecDepend> child = Optional.ofNullable(specNodeFlowDepend).map(SpecFlowDepend::getDepends).orElse(ListUtils.emptyIfNull(null)).stream().filter(dep -> DependencyType.CROSS_CYCLE_CHILDREN.equals(dep.getType())).findAny();
        List other = Optional.ofNullable(specNodeFlowDepend).map(SpecFlowDepend::getDepends).orElse(ListUtils.emptyIfNull(null)).stream().filter(dep -> DependencyType.CROSS_CYCLE_OTHER_NODE.equals(dep.getType())).collect(Collectors.toList());
        if (child.isPresent() && CollectionUtils.isNotEmpty(other)) {
            logger.error("invalid cross cycle depend, violation between cross cycle depends on children and custom other nodes, depends: {}", (Object)specNodeFlowDepend);
            throw new RuntimeException("invalid cross cycle depend, violation between cross cycle depends on children and custom other nodes");
        }
        if (self.isPresent() && child.isPresent()) {
            return DwNodeDependentTypeInfo.ofChildAndSelf();
        }
        if (self.isPresent() && CollectionUtils.isNotEmpty(other)) {
            List outputs = ListUtils.emptyIfNull(other).stream().map(SpecDepend::getOutput).collect(Collectors.toList());
            return DwNodeDependentTypeInfo.ofUserDefineAndSelf(Optional.ofNullable(getNodeIdsByOutputs).map(f -> (List)f.apply(outputs)).orElse(null), outputs.stream().map(SpecNodeOutput::getData).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(other)) {
            List outputs = ListUtils.emptyIfNull(other).stream().map(SpecDepend::getOutput).collect(Collectors.toList());
            return DwNodeDependentTypeInfo.ofUserDefine(Optional.ofNullable(getNodeIdsByOutputs).map(f -> (List)f.apply(outputs)).orElse(null), outputs.stream().map(SpecNodeOutput::getData).collect(Collectors.toList()));
        }
        if (child.isPresent()) {
            return DwNodeDependentTypeInfo.ofChild();
        }
        if (self.isPresent()) {
            return DwNodeDependentTypeInfo.ofSelf();
        }
        return DwNodeDependentTypeInfo.ofNode();
    }

    @Override
    public String getCode() {
        DataWorksNodeCodeAdapter codeAdapter = new DataWorksNodeCodeAdapter(this.delegate.getObject());
        codeAdapter.setContext(this.context);
        return codeAdapter.getCode();
    }

    @Override
    public List<Input> getInputs() {
        return new DataWorksNodeInputOutputAdapter(this.spec, this.delegate.getObject()).getInputs();
    }

    @Override
    public List<Output> getOutputs() {
        return new DataWorksNodeInputOutputAdapter(this.spec, this.delegate.getObject()).getOutputs();
    }

    @Override
    public List<InputContext> getInputContexts() {
        return new DataWorksNodeInputOutputAdapter(this.spec, this.delegate.getObject()).getInputContexts();
    }

    @Override
    public List<OutputContext> getOutputContexts() {
        return new DataWorksNodeInputOutputAdapter(this.spec, this.delegate.getObject()).getOutputContexts();
    }

    @Override
    public String getParaValue() {
        return Optional.ofNullable(this.delegate.getScript()).map(SpecScript::getRuntime).map(SpecScriptRuntime::getCommand).map(cmd -> {
            if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.DIDE_SHELL.name(), (CharSequence)cmd) || StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.PYTHON.name(), (CharSequence)cmd)) {
                return this.getShellParaValue();
            }
            if (ListUtils.emptyIfNull(this.delegate.getScript().getParameters()).stream().anyMatch(v -> VariableType.NO_KV_PAIR_EXPRESSION.equals(v.getType()))) {
                return ListUtils.emptyIfNull(this.delegate.getScript().getParameters()).stream().filter(v -> VariableType.NO_KV_PAIR_EXPRESSION.equals(v.getType())).findAny().map(SpecVariable::getValue).orElse(null);
            }
            return this.getKvParaValue();
        }).or(() -> Optional.ofNullable(this.getKvParaValue())).orElse("");
    }

    private String getKvParaValue() {
        return Optional.ofNullable(this.delegate.getScript()).map(SpecScript::getParameters).map(parameters -> parameters.stream().filter(v -> v.getReferenceVariable() == null).map(p -> p.getName() + "=" + p.getValue()).collect(Collectors.joining(" "))).orElse(null);
    }

    private String getShellParaValue() {
        return ListUtils.emptyIfNull(this.delegate.getScript().getParameters()).stream().sorted(Comparator.comparing(SpecVariable::getName)).filter(v -> v.getReferenceVariable() == null && v.getValue() != null).map(SpecVariable::getValue).collect(Collectors.joining(" "));
    }

    @Override
    public Map<String, Object> getExtConfig() {
        HashMap<String, Object> extConfig = new HashMap<String, Object>();
        SpecNode specNode = (SpecNode)this.delegate.getObject();
        Optional.ofNullable(specNode.getTimeout()).filter(timeout -> timeout > 0).ifPresent(timeout -> extConfig.put(TIMEOUT, specNode.getTimeout()));
        Optional.ofNullable(specNode.getIgnoreBranchConditionSkip()).ifPresent(ignoreBranchConditionSkip -> extConfig.put(IGNORE_BRANCH_CONDITION_SKIP, BooleanUtils.isTrue((Boolean)ignoreBranchConditionSkip)));
        Optional.ofNullable(specNode.getDoWhile()).map(SpecDoWhile::getMaxIterations).ifPresent(maxIterations -> extConfig.put(LOOP_COUNT, maxIterations));
        Optional.ofNullable(specNode.getForeach()).map(SpecForEach::getMaxIterations).ifPresent(maxIterations -> extConfig.put(LOOP_COUNT, maxIterations));
        Optional.ofNullable(specNode.getTrigger()).map(SpecTrigger::getDelaySeconds).ifPresent(delaySeconds -> extConfig.put(DELAY_SECONDS, delaySeconds));
        Optional.ofNullable(specNode.getScript()).map(SpecScript::getRuntime).map(SpecScriptRuntime::getStreamJobConfig).map(emrJobConfig -> emrJobConfig.get(STREAM_LAUNCH_MODE)).map(String::valueOf).filter(StringUtils::isNumeric).map(Integer::valueOf).ifPresent(i -> extConfig.put(STREAM_LAUNCH_MODE, i));
        Optional.ofNullable(specNode.getMetadata()).ifPresent(metadata -> METADATA_KEYS.stream().filter(metadata::containsKey).forEach(key -> extConfig.put((String)key, metadata.get(key))));
        return extConfig;
    }

    @Override
    public Integer getNodeType() {
        if (this.delegate.getObject() instanceof SpecWorkflow) {
            if (((SpecWorkflow)this.delegate.getObject()).getTrigger() != null && TriggerType.CUSTOM.equals(((SpecWorkflow)this.delegate.getObject()).getTrigger().getType())) {
                return NODE_TYPE_MANUAL;
            }
            return Optional.ofNullable(((SpecWorkflow)this.delegate.getObject()).getStrategy()).map(SpecScheduleStrategy::getRecurrenceType).map(DataWorksNodeAdapter::convertRecurrenceType).orElse(null);
        }
        SpecNode specNode = (SpecNode)this.delegate.getObject();
        if (((SpecNode)this.delegate.getObject()).getTrigger() != null && TriggerType.CUSTOM.equals(((SpecNode)this.delegate.getObject()).getTrigger().getType())) {
            return NODE_TYPE_MANUAL;
        }
        if (Optional.ofNullable(specNode.getTrigger()).map(SpecTrigger::getType).map(TriggerType.MANUAL::equals).orElse(false).booleanValue()) {
            return NODE_TYPE_MANUAL;
        }
        return Optional.ofNullable(specNode.getRecurrence()).map(DataWorksNodeAdapter::convertRecurrenceType).orElseThrow(() -> new RuntimeException("not support node type: " + specNode));
    }

    private static Integer convertRecurrenceType(NodeRecurrenceType nodeRecurrenceType) {
        switch (nodeRecurrenceType) {
            case PAUSE: {
                return NODE_TYPE_PAUSE;
            }
            case SKIP: {
                return NODE_TYPE_SKIP;
            }
            case NORMAL: {
                return NODE_TYPE_NORMAL;
            }
            case NONE_AUTO: {
                return NODE_TYPE_NONE_AUTO;
            }
        }
        return null;
    }

    @Override
    public Integer getPrgType(Function<String, Integer> getNodeTypeByName) {
        SpecScriptRuntime runtime = Optional.ofNullable(this.delegate.getScript()).map(SpecScript::getRuntime).orElseThrow(() -> new SpecException("node runtime info not found: " + this.delegate.getScript()));
        return Optional.ofNullable(runtime.getCommandTypeId()).orElseGet(() -> (Integer)Optional.ofNullable(runtime.getCommand()).map(getNodeTypeByName).orElseThrow(() -> new SpecException("unknown node command runtime: " + runtime)));
    }

    @Override
    public String getAdvanceSettings() {
        HashMap settings = new HashMap();
        Optional.ofNullable(this.delegate.getScript()).map(SpecScript::getRuntime).map(SpecScriptRuntime::getEmrJobConfig).filter(MapUtils::isNotEmpty).ifPresent(settings::putAll);
        Optional.ofNullable(this.delegate.getScript()).map(SpecScript::getRuntime).map(SpecScriptRuntime::getCdhJobConfig).filter(MapUtils::isNotEmpty).ifPresent(settings::putAll);
        Optional.ofNullable(this.delegate.getScript()).map(SpecScript::getRuntime).map(SpecScriptRuntime::getAdbJobConfig).filter(MapUtils::isNotEmpty).ifPresent(settings::putAll);
        Optional.ofNullable(this.delegate.getScript()).map(SpecScript::getRuntime).map(SpecScriptRuntime::getLindormJobConfig).filter(MapUtils::isNotEmpty).ifPresent(settings::putAll);
        Optional.ofNullable(this.delegate.getScript()).map(SpecScript::getRuntime).map(SpecScriptRuntime::getSparkConf).filter(MapUtils::isNotEmpty).ifPresent(settings::putAll);
        return MapUtils.isEmpty(settings) ? null : JSON.toJSONString(settings);
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public String getQuota() {
        return Optional.ofNullable(this.delegate.getScript()).map(SpecScript::getRuntime).map(SpecScriptRuntime::getMaxComputeConf).map(conf -> conf.get("quota")).map(String::valueOf).orElse(null);
    }

    public static class Context {
        private boolean deployToScheduler;

        Context(boolean deployToScheduler) {
            this.deployToScheduler = deployToScheduler;
        }

        public static ContextBuilder builder() {
            return new ContextBuilder();
        }

        public boolean isDeployToScheduler() {
            return this.deployToScheduler;
        }

        public void setDeployToScheduler(boolean deployToScheduler) {
            this.deployToScheduler = deployToScheduler;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isDeployToScheduler() == other.isDeployToScheduler();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDeployToScheduler() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "DataWorksNodeAdapter.Context(deployToScheduler=" + this.isDeployToScheduler() + ")";
        }

        public static class ContextBuilder {
            private boolean deployToScheduler;

            ContextBuilder() {
            }

            public ContextBuilder deployToScheduler(boolean deployToScheduler) {
                this.deployToScheduler = deployToScheduler;
                return this;
            }

            public Context build() {
                return new Context(this.deployToScheduler);
            }

            public String toString() {
                return "DataWorksNodeAdapter.Context.ContextBuilder(deployToScheduler=" + this.deployToScheduler + ")";
            }
        }
    }
}

