/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.Code;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiLanguageScriptingCode
extends AbstractBaseCode {
    public static final String LANGUAGE_PYTHON = "python";
    public static final String LANGUAGE_SHELL = "shell";
    public static final String LANGUAGE_ODPS_SQL = "odps";
    private String language;
    private String content;

    @Override
    public Code parse(String code) {
        Type type = new TypeToken<MultiLanguageScriptingCode>(){}.getType();
        MultiLanguageScriptingCode msc = (MultiLanguageScriptingCode)GsonUtils.fromJsonString(code, type);
        Optional.ofNullable(msc).ifPresent(m -> {
            this.content = m.getSourceCode();
            this.language = m.getLanguage();
        });
        return this;
    }

    @Override
    public List<String> getProgramTypes() {
        return Stream.of(CodeProgramType.CONTROLLER_ASSIGNMENT, CodeProgramType.CONTROLLER_CYCLE_END).map(Enum::name).distinct().collect(Collectors.toList());
    }

    @Override
    public void setSourceCode(String sourceCode) {
        this.content = sourceCode;
    }

    @Override
    public String getSourceCode() {
        return this.content;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiLanguageScriptingCode)) {
            return false;
        }
        MultiLanguageScriptingCode other = (MultiLanguageScriptingCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$content = this.content;
        String other$content = other.content;
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiLanguageScriptingCode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $content = this.content;
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MultiLanguageScriptingCode(language=" + this.getLanguage() + ", content=" + this.content + ")";
    }

    public String getLanguage() {
        return this.language;
    }

    public MultiLanguageScriptingCode setLanguage(String language) {
        this.language = language;
        return this;
    }
}

