/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.ConvertTreeReaderFactory;

public class SchemaEvolution {
    private final Map<TypeDescription, TypeDescription> readerToFile;
    private final boolean[] included;
    private final TypeDescription readerSchema;
    private static final Log LOG = LogFactory.getLog(SchemaEvolution.class);
    public static final List<String> acidEventFieldNames = new ArrayList<String>();

    public SchemaEvolution(TypeDescription readerSchema, boolean[] included) {
        this.included = included;
        this.readerToFile = null;
        this.readerSchema = readerSchema;
    }

    public SchemaEvolution(TypeDescription fileSchema, TypeDescription readerSchema, boolean[] included) throws IOException {
        this.readerToFile = new HashMap<TypeDescription, TypeDescription>(readerSchema.getMaximumId() + 1);
        this.included = included;
        this.readerSchema = SchemaEvolution.checkAcidSchema(fileSchema) ? SchemaEvolution.createEventSchema(readerSchema) : readerSchema;
        this.buildMapping(fileSchema, this.readerSchema);
    }

    public TypeDescription getReaderSchema() {
        return this.readerSchema;
    }

    public TypeDescription getFileType(TypeDescription readerType) {
        TypeDescription result = this.readerToFile == null ? (this.included == null || this.included[readerType.getId()] ? readerType : null) : this.readerToFile.get(readerType);
        return result;
    }

    void buildMapping(TypeDescription fileType, TypeDescription readerType) throws IOException {
        boolean isOk;
        block14: {
            block13: {
                if (this.included != null && !this.included[readerType.getId()]) {
                    return;
                }
                isOk = true;
                if (fileType.getCategory() != readerType.getCategory()) break block13;
                switch (readerType.getCategory()) {
                    case BOOLEAN: 
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case STRING: 
                    case TIMESTAMP: 
                    case BINARY: 
                    case DATE: {
                        break block14;
                    }
                    case CHAR: 
                    case VARCHAR: {
                        isOk = fileType.getMaxLength() == readerType.getMaxLength();
                        break block14;
                    }
                    case DECIMAL: {
                        break block14;
                    }
                    case UNION: 
                    case MAP: 
                    case LIST: {
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        if (fileChildren.size() == readerChildren.size()) {
                            for (int i = 0; i < fileChildren.size(); ++i) {
                                this.buildMapping(fileChildren.get(i), readerChildren.get(i));
                            }
                        } else {
                            isOk = false;
                        }
                        break block14;
                    }
                    case STRUCT: {
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        int jointSize = Math.min(fileChildren.size(), readerChildren.size());
                        for (int i = 0; i < jointSize; ++i) {
                            this.buildMapping(fileChildren.get(i), readerChildren.get(i));
                        }
                        break block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + readerType);
                    }
                }
            }
            isOk = ConvertTreeReaderFactory.canConvert(fileType, readerType);
        }
        if (!isOk) {
            throw new IOException(String.format("ORC does not support type conversion from file type %s (%d) to reader type %s (%d)", fileType.toString(), fileType.getId(), readerType.toString(), readerType.getId()));
        }
        this.readerToFile.put(readerType, fileType);
    }

    private static boolean checkAcidSchema(TypeDescription type) {
        List<String> rootFields;
        return type.getCategory().equals((Object)TypeDescription.Category.STRUCT) && acidEventFieldNames.equals(rootFields = type.getFieldNames());
    }

    public static TypeDescription createEventSchema(TypeDescription typeDescr) {
        TypeDescription result = TypeDescription.createStruct().addField("operation", TypeDescription.createInt()).addField("originalTransaction", TypeDescription.createLong()).addField("bucket", TypeDescription.createInt()).addField("rowId", TypeDescription.createLong()).addField("currentTransaction", TypeDescription.createLong()).addField("row", typeDescr.clone());
        return result;
    }

    static {
        acidEventFieldNames.add("operation");
        acidEventFieldNames.add("originalTransaction");
        acidEventFieldNames.add("bucket");
        acidEventFieldNames.add("rowId");
        acidEventFieldNames.add("currentTransaction");
        acidEventFieldNames.add("row");
    }
}

