/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.workflow.migration.core;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.utils.IdCenter;
import com.aliyun.migration.workflow.migration.domain.model.JobDescDTO;
import com.aliyun.workflow.migration.core.Task;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCompiler {
    private static final Logger log = LoggerFactory.getLogger(JobCompiler.class);
    private String jobId;
    private JobDescDTO jobDescDTO;

    public JobCompiler(String jobId, JobDescDTO jobDescDTO) {
        this.jobId = jobId;
        this.jobDescDTO = jobDescDTO;
    }

    public List<Task> compile() {
        if (Objects.isNull(this.jobDescDTO)) {
            log.warn("[task-compile] taskDescDTO is null,can not compile task");
            return Collections.emptyList();
        }
        TaskContext taskContext = this.buildTaskContext();
        switch (this.jobDescDTO.getTaskType()) {
            case Reader: {
                return this.buildReaderTask(this.jobId, taskContext);
            }
            case Writer: {
                return this.buildWriterTask(this.jobId, taskContext);
            }
            case Converter: {
                return this.buildConvertTask(this.jobId, taskContext);
            }
        }
        log.warn("[task-compile] task type is not supported,taskType:{}", (Object)this.jobDescDTO.getTaskType());
        return Collections.emptyList();
    }

    private TaskContext buildTaskContext() {
        TaskContext taskContext = new TaskContext();
        taskContext.setSourceFilePackage(this.jobDescDTO.getSourceFilePackage());
        taskContext.setTargetFilePackage(this.jobDescDTO.getTargetFilePackage());
        taskContext.setConverterName(this.jobDescDTO.getCoverterName());
        taskContext.setReaderName(this.jobDescDTO.getReaderName());
        taskContext.setWriterName(this.jobDescDTO.getWriterName());
        taskContext.setMigrationxJson(this.jobDescDTO.getBwmConfiguration());
        taskContext.setReaderDatasource(this.jobDescDTO.getReaderDatasource());
        taskContext.setWriterDatasource(this.jobDescDTO.getWriterDatasource());
        taskContext.setBwmConfiguration(this.jobDescDTO.getBwmConfiguration());
        return taskContext;
    }

    private List<Task> buildReaderTask(String jobId, TaskContext taskContext) {
        return null;
    }

    private List<Task> buildConvertTask(String jobId, TaskContext taskContext) {
        return null;
    }

    private List<Task> buildWriterTask(String jobId, TaskContext taskContext) {
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobDescDTO getJobDescDTO() {
        return this.jobDescDTO;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setJobDescDTO(JobDescDTO jobDescDTO) {
        this.jobDescDTO = jobDescDTO;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobCompiler)) {
            return false;
        }
        JobCompiler other = (JobCompiler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        JobDescDTO this$jobDescDTO = this.getJobDescDTO();
        JobDescDTO other$jobDescDTO = other.getJobDescDTO();
        return !(this$jobDescDTO == null ? other$jobDescDTO != null : !this$jobDescDTO.equals(other$jobDescDTO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobCompiler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        JobDescDTO $jobDescDTO = this.getJobDescDTO();
        result = result * 59 + ($jobDescDTO == null ? 43 : $jobDescDTO.hashCode());
        return result;
    }

    public String toString() {
        return "JobCompiler(jobId=" + this.getJobId() + ", jobDescDTO=" + this.getJobDescDTO() + ")";
    }

    static {
        IdCenter.init((Long)0L, (Long)0L);
    }
}

