/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util.matcher;

import com.aliyun.securitysdk.util.matcher.StringMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class SetBasedStringMatcher
implements StringMatcher {
    protected final Set<String> SET;

    public SetBasedStringMatcher(Collection<String> collection) {
        this.SET = new CopyOnWriteArraySet(collection == null ? Collections.emptySet() : collection);
    }

    public SetBasedStringMatcher addItem(String item) {
        this.SET.add(item);
        return this;
    }

    public SetBasedStringMatcher addItems(Collection<String> collection) {
        this.SET.addAll(collection);
        return this;
    }

    public SetBasedStringMatcher removeItem(String item) {
        this.SET.remove(item);
        return this;
    }

    public SetBasedStringMatcher removeItems(Collection<String> items) {
        this.SET.removeAll(items);
        return this;
    }

    public Set<String> items() {
        return Collections.unmodifiableSet(this.SET);
    }

    @Override
    public boolean matches(String text) {
        return this.SET.contains(text);
    }

    @Override
    public void clear() {
        this.SET.clear();
    }
}

