/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.rapt.commons.utils.IOUtils;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class PhoneNumberUtil {
    private static final Logger logger = SecurityLogManager.getLogger(PhoneNumberUtil.class);
    private static final Map<String, String> regionCodeMap = new HashMap<String, String>();

    public static PhoneNumber parsePhoneNumber(String number) {
        if (number == null || number.isEmpty()) {
            return null;
        }
        PhoneNumber ret = new PhoneNumber();
        ret.setRawNumber(number);
        ret.setRealNumber(number);
        if (number.charAt(0) == '+') {
            int i;
            StringBuilder regionNumber = new StringBuilder();
            String regionCode = "";
            for (i = 1; i < number.length() && i < 5; ++i) {
                char c = number.charAt(i);
                regionNumber.append(c);
                regionCode = regionCodeMap.get(regionNumber.toString());
                if (regionCode != null && !regionCode.isEmpty()) break;
            }
            if (regionCode == null || regionCode.isEmpty()) {
                ret.setRealNumber(number);
                return ret;
            }
            ret.setRegionCode(regionCode);
            ++i;
            while (i < number.length() && number.charAt(i) == ' ') {
                ++i;
            }
            if (i >= number.length()) {
                ret.setRealNumber("");
            }
            ret.setPrefix(number.substring(0, i));
            ret.setRealNumber(number.substring(i));
            return ret;
        }
        if (number.charAt(0) == '(') {
            int i;
            int idx = number.indexOf(41);
            if (idx == -1 || idx > 5) {
                return ret;
            }
            for (i = idx + 1; i < number.length() && number.charAt(i) == ' '; ++i) {
            }
            if (i >= number.length()) {
                ret.setRealNumber("");
            } else {
                ret.setRealNumber(number.substring(i));
            }
            ret.setPrefix(number.substring(0, i));
            StringBuilder regionNumber = new StringBuilder();
            for (int j = 0; j < ret.getPrefix().length(); ++j) {
                char c = ret.getPrefix().charAt(j);
                if (c < '0' || c > '9') continue;
                regionNumber.append(c);
            }
            String regionCode = regionCodeMap.get(regionNumber.toString());
            if (regionCode != null) {
                ret.setRegionCode(regionCode);
            }
            return ret;
        }
        return ret;
    }

    static {
        try {
            InputStream phoneMetaData = PhoneNumberUtil.class.getResourceAsStream("/phone/metadata.txt");
            for (String line : IOUtils.readLines((InputStream)phoneMetaData, (Charset)StandardCharsets.UTF_8)) {
                String data = line.trim();
                int splitIndex = data.indexOf(44);
                regionCodeMap.put(data.substring(0, splitIndex), data.substring(splitIndex + 1));
            }
        }
        catch (Exception e) {
            logger.warn("load phone number metadata error", (Throwable)e);
        }
    }

    public static class PhoneNumber {
        private String rawNumber;
        private String RegionCode = "CN";
        private String prefix = "";
        private String realNumber;

        public String getRawNumber() {
            return this.rawNumber;
        }

        public String getRegionCode() {
            return this.RegionCode;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getRealNumber() {
            return this.realNumber;
        }

        public void setRawNumber(String rawNumber) {
            this.rawNumber = rawNumber;
        }

        public void setRegionCode(String RegionCode) {
            this.RegionCode = RegionCode;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setRealNumber(String realNumber) {
            this.realNumber = realNumber;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhoneNumber)) {
                return false;
            }
            PhoneNumber other = (PhoneNumber)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$rawNumber = this.getRawNumber();
            String other$rawNumber = other.getRawNumber();
            if (this$rawNumber == null ? other$rawNumber != null : !this$rawNumber.equals(other$rawNumber)) {
                return false;
            }
            String this$RegionCode = this.getRegionCode();
            String other$RegionCode = other.getRegionCode();
            if (this$RegionCode == null ? other$RegionCode != null : !this$RegionCode.equals(other$RegionCode)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            String this$realNumber = this.getRealNumber();
            String other$realNumber = other.getRealNumber();
            return !(this$realNumber == null ? other$realNumber != null : !this$realNumber.equals(other$realNumber));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PhoneNumber;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $rawNumber = this.getRawNumber();
            result = result * 59 + ($rawNumber == null ? 43 : $rawNumber.hashCode());
            String $RegionCode = this.getRegionCode();
            result = result * 59 + ($RegionCode == null ? 43 : $RegionCode.hashCode());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            String $realNumber = this.getRealNumber();
            result = result * 59 + ($realNumber == null ? 43 : $realNumber.hashCode());
            return result;
        }

        public String toString() {
            return "PhoneNumberUtil.PhoneNumber(rawNumber=" + this.getRawNumber() + ", RegionCode=" + this.getRegionCode() + ", prefix=" + this.getPrefix() + ", realNumber=" + this.getRealNumber() + ")";
        }
    }
}

