/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf.strategy;

import com.aliyun.securitysdk.rass.api.config.ConfigLoader;
import com.aliyun.securitysdk.rass.api.config.RassConfig;
import com.aliyun.securitysdk.rass.util.InetAddressResolver;
import com.aliyun.securitysdk.url.ssrf.strategy.InetAddressHostnameResolveStrategy;
import com.aliyun.securitysdk.util.IpFormatter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class InetAddressHostnameResolveStrategies {
    static InetAddressHostnameResolveStrategy defaultStrategy;

    static void init() {
        RassConfig securityConfig = ConfigLoader.loadSecurityConfig();
        String strategyName = securityConfig.getSsrfInetAddressHostnameResolveStrategy();
        defaultStrategy = "normal".equals(strategyName) ? new NormalInetAddresssHostnameResolveStrategy() : new ReflectedInetAddresssHostnameResolveStrategy();
    }

    public static String resolve(InetAddress inetAddress) {
        return defaultStrategy.resolve(inetAddress);
    }

    public static List<String> resolves(InetAddress inetAddress) {
        return defaultStrategy.resolves(inetAddress);
    }

    static {
        InetAddressHostnameResolveStrategies.init();
    }

    public static class ReflectedInetAddresssHostnameResolveStrategy
    extends NormalInetAddresssHostnameResolveStrategy {
        private final InetAddressResolver inetAddressResolver = new InetAddressResolver();

        @Override
        public String resolve(InetAddress inetAddress) {
            String hostName = this.inetAddressResolver.findInetAddressHoldingHostName(inetAddress);
            return hostName == null ? inetAddress.getHostAddress() : hostName;
        }

        @Override
        public String getName() {
            return "reflect";
        }
    }

    public static class NormalInetAddresssHostnameResolveStrategy
    implements InetAddressHostnameResolveStrategy {
        @Override
        public String resolve(InetAddress inetAddress) {
            return inetAddress.getHostName();
        }

        @Override
        public List<String> resolves(InetAddress inetAddress) {
            ArrayList<String> hostnames = new ArrayList<String>();
            hostnames.add(this.resolve(inetAddress));
            if (inetAddress instanceof Inet4Address) {
                byte[] address = inetAddress.getAddress();
                hostnames.add(IpFormatter.format8(address));
                hostnames.add(IpFormatter.format10(address));
                hostnames.add(IpFormatter.format16(address));
                hostnames.add(IpFormatter.format8Ddn(address));
                hostnames.add(IpFormatter.format10Ddn(address));
                hostnames.add(IpFormatter.format16Ddn(address));
            }
            return hostnames;
        }

        @Override
        public String getName() {
            return "normal";
        }
    }
}

