/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf.interceptor;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.SecurityUtil;
import com.aliyun.securitysdk.url.SSRFChecker;
import com.aliyun.securitysdk.url.exception.GlobalSSRFThrowableFactory;
import java.io.IOException;
import java.net.InetAddress;
import okhttp3.Interceptor;
import okhttp3.Response;

public class OK3Interceptor
implements Interceptor {
    private static final Logger logger = SecurityLogManager.getLogger(OK3Interceptor.class);
    private static final SSRFChecker ssrfChecker = SecurityUtil.getSSRFCheckerSingleton();
    public static final OK3Interceptor INSTANCE = new OK3Interceptor();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String url = chain.request().url().toString();
        if (!ssrfChecker.checkUrlWithoutConnection(url, true)) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName(chain.request().url().host());
            }
            catch (Exception e) {
                logger.info("get name error", (Throwable)e);
            }
            logger.warn("ssrf attack, url: {}, address: {}", (Object)url, (Object)address);
            throw GlobalSSRFThrowableFactory.defaultFactory().newRuntimeException("unsafe url: " + url, address);
        }
        ssrfChecker.startNetHookWithExpirationCache(url);
        return chain.proceed(chain.request());
    }
}

