/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf.interceptor;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.SecurityUtil;
import com.aliyun.securitysdk.url.SSRFChecker;
import com.aliyun.securitysdk.url.exception.GlobalSSRFThrowableFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;

public class HttpClient5Interceptor
implements ExecChainHandler,
AsyncExecChainHandler {
    private static final Logger logger = SecurityLogManager.getLogger(HttpClient5Interceptor.class);
    public static final HttpClient5Interceptor INSTANCE = new HttpClient5Interceptor();
    private final SSRFChecker ssrfChecker = SecurityUtil.getSSRFCheckerSingleton();

    private void startNetHookChecker(HttpRequest httpRequest) {
        URI uri = null;
        try {
            uri = httpRequest.getUri();
        }
        catch (URISyntaxException e) {
            logger.warn("ssrfchecker get uri error", (Throwable)e);
            throw GlobalSSRFThrowableFactory.defaultFactory().newRuntimeException("get uri error" + e.getMessage(), null);
        }
        String url = uri.toString();
        if (!this.ssrfChecker.checkUrlWithoutConnection(url, true)) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName(uri.getHost());
            }
            catch (Exception e) {
                logger.info("get name error", (Throwable)e);
            }
            logger.warn("ssrf attack, url: {}, address: {}", (Object)url, (Object)address);
            throw GlobalSSRFThrowableFactory.defaultFactory().newRuntimeException("unsafe url: " + uri, address);
        }
        this.ssrfChecker.startNetHookWithExpirationCache(uri.toString());
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        this.startNetHookChecker((HttpRequest)request);
        return chain.proceed(request, scope);
    }

    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        this.startNetHookChecker(request);
        chain.proceed(request, entityProducer, scope, asyncExecCallback);
    }
}

