/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask.model.guest;

import com.aliyun.securitysdk.mask.DataType;
import com.aliyun.securitysdk.mask.model.guest.AbstractGuestMaskModel;
import com.aliyun.securitysdk.util.SensitiveDataUtil;

public class EmailWebGuestMaskModel
extends AbstractGuestMaskModel {
    @Override
    public DataType getDataType() {
        return DataType.Email_Web;
    }

    @Override
    public String doMask(String input) {
        String prefix = "";
        String domain = "";
        int idx = input.indexOf(64);
        if (idx == -1) {
            prefix = input;
        } else {
            prefix = input.substring(0, idx);
            domain = input.substring(idx);
        }
        return this.maskEmail(prefix, domain);
    }

    public String maskEmail(String prefix, String domain) {
        prefix = prefix.isEmpty() ? "***" : (prefix.length() <= 4 ? prefix.charAt(0) + "***" : SensitiveDataUtil.customizeIntraMark(prefix, 3, 1, 3));
        return prefix + domain;
    }

    @Override
    protected boolean isValidationSupported() {
        return true;
    }

    @Override
    public boolean validate(String input) {
        return SensitiveDataUtil.isEmailAddress(input);
    }
}

