/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask.model.guest;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.mask.DataType;
import com.aliyun.securitysdk.mask.division.AdministrativeDivision;
import com.aliyun.securitysdk.mask.division.AreaNormalizer;
import com.aliyun.securitysdk.mask.division.CainiaoAreaNormalizerFactory;
import com.aliyun.securitysdk.mask.division.SimpleAreaNormalizer;
import com.aliyun.securitysdk.mask.model.guest.AbstractGuestMaskModel;
import com.aliyun.securitysdk.util.ClassUtils;

public class AddressGuestMaskModel
extends AbstractGuestMaskModel {
    private static final Logger logger = SecurityLogManager.getLogger(AddressGuestMaskModel.class);
    private static final String AREA_NORMALIZER_NAME = "com.alibaba.securitysdk.division.CainiaoAreaNormalizer";
    private static final AreaNormalizer NORMALIZER;

    @Override
    public String doMask(String input) {
        AdministrativeDivision division = NORMALIZER.normalize(input);
        return division.normalizedDivision();
    }

    @Override
    public DataType getDataType() {
        return DataType.Address;
    }

    static {
        if (ClassUtils.isPresent(AREA_NORMALIZER_NAME, ClassUtils.getDefaultClassLoader())) {
            NORMALIZER = CainiaoAreaNormalizerFactory.createAreaNormalizer();
            logger.info("com.alibaba.securitysdk.division.CainiaoAreaNormalizer is not present. SimpleAreaNormalizer will be used by default.");
        } else {
            NORMALIZER = new SimpleAreaNormalizer();
        }
    }
}

