/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask.division;

import com.alibaba.securitysdk.fastjson.JSON;
import com.alibaba.securitysdk.fastjson.JSONArray;
import com.alibaba.securitysdk.fastjson.JSONObject;
import com.aliyun.securitysdk.mask.division.model.AreaEntity;
import com.aliyun.securitysdk.mask.division.model.CityEntity;
import com.aliyun.securitysdk.mask.division.model.DivisionEntity;
import com.aliyun.securitysdk.mask.division.model.Entity;
import com.aliyun.securitysdk.mask.division.model.ProvinceEntity;
import com.aliyun.securitysdk.url.CannotLoadResourcesException;
import com.aliyun.securitysdk.util.Function;
import com.aliyun.securitysdk.util.IOUtils;
import com.aliyun.securitysdk.util.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DivisionLoader {
    instance;

    private static final String PROVINCE_JSON_PATH = "area/province.json";
    private static final String CITY_JSON_PATH = "area/city.json";
    private static final String AREA_JSON_PATH = "area/area.json";
    private Map<String, DivisionEntity> namedDivisionEntityMap;
    private Map<Integer, DivisionEntity> idDivisionEntityMap;

    private DivisionLoader() {
        try {
            this.init();
        }
        catch (IOException e) {
            String info = "area/province.json or area/city.json or area/area.json";
            throw new CannotLoadResourcesException(info, (Exception)e);
        }
    }

    private void init() throws IOException {
        this.namedDivisionEntityMap = new HashMap<String, DivisionEntity>();
        this.idDivisionEntityMap = new HashMap<Integer, DivisionEntity>();
        this.loadProvinceEntity(PROVINCE_JSON_PATH);
        this.loadCityEntity(CITY_JSON_PATH);
        this.loadAreaEntity(AREA_JSON_PATH);
        this.loadAmbiguousEntries();
    }

    private void loadAmbiguousEntries() {
        HashMap<String, DivisionEntity> tempNamedMap = new HashMap<String, DivisionEntity>(this.namedDivisionEntityMap.size());
        for (Map.Entry<String, DivisionEntity> entry : this.namedDivisionEntityMap.entrySet()) {
            String key = entry.getKey();
            if (key.length() <= 2) continue;
            tempNamedMap.put(key.substring(0, key.length() - 1), entry.getValue());
        }
        this.namedDivisionEntityMap.putAll(tempNamedMap);
    }

    public Map<String, DivisionEntity> getNamedDivisionEntityMap() {
        return this.namedDivisionEntityMap;
    }

    public Map<Integer, DivisionEntity> getIdDivisionEntityMap() {
        return this.idDivisionEntityMap;
    }

    private void loadCityEntity(String path) throws IOException {
        this.loadCityOrAreaEntity(path, CityEntity.class);
    }

    private void loadAreaEntity(String path) throws IOException {
        this.loadCityOrAreaEntity(path, AreaEntity.class);
    }

    private <T extends DivisionEntity> void loadCityOrAreaEntity(String path, Class<T> clazz) throws IOException {
        String data = IOUtils.readToString(path);
        JSONObject jsonObject = JSON.parseObject((String)data);
        for (Map.Entry entry : jsonObject.entrySet()) {
            List areaEntities = JSONArray.parseArray((String)entry.getValue().toString(), clazz);
            this.namedDivisionEntityMap.putAll(this.listToNamedMap(areaEntities));
            this.idDivisionEntityMap.putAll(this.listToIdMap(areaEntities));
        }
    }

    private void loadProvinceEntity(String path) throws IOException {
        String data = IOUtils.readToString(path);
        List provinceEntities = JSONArray.parseArray((String)data, ProvinceEntity.class);
        this.namedDivisionEntityMap.putAll(this.listToNamedMap(provinceEntities));
        this.idDivisionEntityMap.putAll(this.listToIdMap(provinceEntities));
    }

    private <T extends DivisionEntity> Map<String, T> listToNamedMap(List<T> list) {
        return Maps.index(list, new Function<T, String>(){

            @Override
            public String apply(T provinceEntity) {
                return ((DivisionEntity)provinceEntity).getName();
            }
        });
    }

    private <T extends DivisionEntity> Map<Integer, T> listToIdMap(List<T> list) {
        return Maps.index(list, new Function<T, Integer>(){

            @Override
            public Integer apply(T provinceEntity) {
                return ((Entity)provinceEntity).getId();
            }
        });
    }
}

