/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;

public class UserPassUrlParser
extends DefaultUrlParser {
    protected String user = "";
    protected String password = "";

    @Override
    protected void parseHost(String hostAddressesString) throws JdbcURLException {
        int atIndex = hostAddressesString.lastIndexOf(64);
        String authBlock = "";
        if (atIndex >= 0) {
            authBlock = hostAddressesString.substring(0, atIndex);
            hostAddressesString = hostAddressesString.substring(atIndex + 1);
        }
        this.setAuth(authBlock);
        super.parseHost(hostAddressesString);
    }

    protected void setAuth(String authBlock) throws JdbcURLException {
        if (authBlock.isEmpty()) {
            return;
        }
        int colonCount = this.countOccurrences(authBlock, ":");
        if (authBlock.contains("@") || colonCount > 1) {
            throw new JdbcURLUnsafeException("The connection string contains invalid user information: " + this.initialUrl);
        }
        if (colonCount == 0) {
            this.user = authBlock;
        } else {
            int idx = authBlock.indexOf(":");
            this.user = authBlock.substring(0, idx);
            this.password = authBlock.substring(idx + 1);
        }
    }

    private int countOccurrences(String haystack, String needle) {
        return haystack.length() - haystack.replace(needle, "").length();
    }

    @Override
    public String toString() {
        String authBlock = "";
        if (!this.user.isEmpty()) {
            authBlock = this.user;
            if (!this.password.isEmpty()) {
                authBlock = authBlock + ":" + this.password;
            }
            authBlock = authBlock + "@";
        }
        return this.scheme + "//" + authBlock + this.host + (this.port > -1 ? ":" + this.port : "") + (this.database != null ? "/" + this.database : "") + (this.properties.isEmpty() ? "" : this.getParamMarker() + this.propertiesToString());
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }
}

