/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import com.aliyun.securitysdk.jdbc.parser.oracle.NVFactory;
import com.aliyun.securitysdk.jdbc.parser.oracle.NVPair;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleUrlParser
extends DefaultUrlParser {
    private static final Pattern HOST_INFO_PATTERN = Pattern.compile("(?<hostnames>(((\\[[A-z0-9:]+\\])|([A-z0-9][A-z0-9._-]+)),?)+)(:(?<port>\\d+))?");
    private static final Pattern EZ_URL_PATTERN = Pattern.compile("^((?<protocol>tcp|tcps):)?(//)?(?<hostinfo>(" + HOST_INFO_PATTERN.pattern() + ")+)(/(?<servicename>[A-z][A-z0-9,-.]+))?(:(?<servermode>dedicated|shared|pooled))?(/(?<instance>[A-z][A-z0-9]+))?$", 2);
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:oracle:(thin|oci|oci8|kprb):\\w*/?\\w*@(//)?[A-z0-9-._]+(:\\d+)[:/][A-z0-9-._:]+");
    private static final Pattern OLD_URL_SPLITTER = Pattern.compile("(?i)jdbc:(oracle|default):(thin|oci[8]?|kprb|connection)(?-i)(:(((([\\w\\[\\]$#]*)|(\"[^\u0000\"]+\"))/(([\\w$#\\(\\)\\!]*)|(\"[^\u0000\"]+\")))?@(.*)?)?)?", 40);
    private String connectionString;
    private NVPair nvPair;

    @Override
    public void parse(String url) throws JdbcURLException {
        if (!url.regionMatches(true, 0, "jdbc:oracle:thin:@", 0, 18)) {
            throw new JdbcURLUnsafeException("url not supported: " + url);
        }
        this.initialUrl = url;
        this.scheme = "jdbc:oracle:thin:";
        String originalUrl = url;
        if ((url = url.substring(18)).isEmpty()) {
            throw new JdbcURLUnsafeException("invalid url: " + originalUrl);
        }
        if (!URL_PATTERN.matcher(url).matches()) {
            if (url.startsWith("(")) {
                this.parseTNSURLFormat(url);
            } else {
                int paramIndex = url.indexOf("?");
                if (paramIndex > -1) {
                    this.parseProperties(url.substring(paramIndex + 1));
                    url = url.substring(0, paramIndex);
                }
                this.parseEzConnectFormat(url);
            }
        } else {
            this.connectionString = originalUrl;
        }
        this.parseConnectionString();
    }

    private void parseEzConnectFormat(String url) throws JdbcURLException {
        url = url.replaceAll("\\s+", "");
        this.connectionString = "jdbc:oracle:thin:@" + url;
    }

    private void parseConnectionString() throws JdbcURLException {
        if (this.connectionString == null || this.connectionString.equals("")) {
            return;
        }
        Matcher matcher = OLD_URL_SPLITTER.matcher(this.connectionString);
        if (!matcher.matches()) {
            throw new JdbcURLUnsafeException("invalid url format: " + this.connectionString);
        }
        String db = matcher.group(12);
        if (db.equals("")) {
            throw new JdbcURLUnsafeException("invalid url: " + this.connectionString);
        }
        int questionMarkIndex = db.indexOf(63);
        if (questionMarkIndex >= 0) {
            db = db.substring(0, questionMarkIndex);
        }
        this.connectionString = this.connectionString.substring(0, matcher.start(12)) + db;
        int atIndex = this.connectionString.indexOf(64);
        this.connectionString = this.connectionString.substring(atIndex + 1);
    }

    private void parseTNSURLFormat(String url) throws JdbcURLException {
        url = url.startsWith("alias") ? url : "alias=" + url;
        url = url.charAt(0) == '(' ? url : "(" + url + ")";
        this.nvPair = new NVFactory().createNVPair(url);
        if (this.nvPair == null || this.nvPair.getListSize() != 1) {
            throw new JdbcURLUnsafeException("invalid url format: " + url);
        }
    }

    @Override
    public String toString() {
        String url = this.scheme + "@";
        if (this.nvPair != null) {
            if (this.nvPair.getListSize() < 1) {
                return url;
            }
            NVPair subPair = this.nvPair.getListElement(0);
            if (subPair == null) {
                return url;
            }
            url = url + subPair.toString();
        } else {
            url = url + this.connectionString + (this.properties.isEmpty() ? "" : "?" + this.propertiesToString());
        }
        return url;
    }

    public NVPair getNvPair() {
        return this.nvPair;
    }

    public void setNvPair(NVPair nvPair) {
        this.nvPair = nvPair;
    }
}

