/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import java.util.regex.Pattern;

public class BigQueryParser
extends DefaultUrlParser {
    private static final String PARAM_MARKER = ";";
    private static final String PARAM_SEPARATOR = ";";
    private static final Pattern HOST_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.:/]+$");

    @Override
    protected String getParamMarker() {
        return ";";
    }

    @Override
    protected String getParamSeparator() {
        return ";";
    }

    @Override
    public Pattern getHostPattern() {
        return HOST_PATTERN;
    }

    @Override
    protected void parseUrlWithoutScheme(String urlSecondPart) throws JdbcURLException {
        String additionalParameters;
        String hostAddressesString;
        int paramIndex = urlSecondPart.indexOf(this.getParamMarker());
        if (paramIndex > 0) {
            hostAddressesString = urlSecondPart.substring(0, paramIndex);
            additionalParameters = urlSecondPart.substring(paramIndex + 1);
        } else if (paramIndex < 0) {
            hostAddressesString = urlSecondPart;
            additionalParameters = null;
        } else {
            throw new JdbcURLUnsafeException("invalid jdbc url: " + this.initialUrl);
        }
        this.parseHost(hostAddressesString);
        this.parseProperties(additionalParameters);
    }

    @Override
    protected void parseHost(String hostAddressesString) throws JdbcURLException {
        String hostString;
        int slashIndex = hostAddressesString.indexOf("/");
        int portIndex = 0;
        portIndex = slashIndex >= 0 ? hostAddressesString.indexOf(":", slashIndex) : hostAddressesString.indexOf(":");
        String portString = null;
        if (portIndex == -1) {
            hostString = hostAddressesString;
        } else {
            hostString = hostAddressesString.substring(0, portIndex);
            portString = hostAddressesString.substring(portIndex + 1);
        }
        if (!this.getHostPattern().matcher(hostString).matches()) {
            throw new JdbcURLUnsafeException("invalid host '" + hostString + "' in url: " + this.initialUrl);
        }
        this.host = hostString;
        if (portString != null && !portString.isEmpty()) {
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new JdbcURLUnsafeException("invalid host " + hostAddressesString + " in url: " + this.initialUrl);
            }
            if (this.port < 0 || this.port > 65535) {
                throw new JdbcURLUnsafeException("invalid port " + portString + " in url: " + this.initialUrl);
            }
        } else {
            this.port = -1;
        }
    }

    @Override
    public String toString() {
        return this.scheme + "//" + this.host + (this.port > -1 ? ":" + this.port : "") + (this.properties.isEmpty() ? "" : this.getParamMarker() + this.propertiesToString() + ";");
    }
}

