/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.decorator.xxe;

import com.aliyun.securitysdk.decorator.AbstractDecorator;
import java.lang.reflect.Method;

public class SetPropertyDecorator
extends AbstractDecorator {
    private static final Class<?> sfClass = SetPropertyDecorator.classForNameQuietly("javax.xml.validation.SchemaFactory");
    private static final Class<?> validatorClass = SetPropertyDecorator.classForNameQuietly("javax.xml.validation.Validator");
    private static final Class<?> tfClass = SetPropertyDecorator.classForNameQuietly("javax.xml.transform.TransformerFactory");

    public boolean accept(Object clientOrBuilder) {
        return sfClass != null && sfClass.isInstance(clientOrBuilder) || validatorClass != null && validatorClass.isInstance(clientOrBuilder) || tfClass != null && tfClass.isInstance(clientOrBuilder);
    }

    public <T> T decorate(T builder) {
        boolean isTf = tfClass != null && tfClass.isInstance(builder);
        try {
            String methodName = isTf ? "setAttribute" : "setProperty";
            Method m = builder.getClass().getMethod(methodName, String.class, Object.class);
            m.setAccessible(true);
            m.invoke(builder, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            if (isTf) {
                m.invoke(builder, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            } else {
                m.invoke(builder, "http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("can not decorate builder " + builder.getClass().getName(), e);
        }
        return builder;
    }
}

