/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.authorization;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.authorization.AuthLogger;
import com.aliyun.securitysdk.authorization.AuthLoggerFactory;
import com.aliyun.securitysdk.authorization.AuthorizationLogger;
import com.aliyun.securitysdk.authorization.BaseLog;
import com.aliyun.securitysdk.authorization.InterceptType;
import com.aliyun.securitysdk.authorization.RequestInfo;
import com.aliyun.securitysdk.authorization.RiskLevel;
import com.aliyun.securitysdk.authorization.TargetType;
import com.aliyun.securitysdk.authorization.UserType;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class AuthorizationLoggerImpl
extends BaseLog
implements AuthorizationLogger {
    private static final Logger logger = SecurityLogManager.getLogger(AuthorizationLoggerImpl.class);
    private boolean logStackTrace = true;
    private final AuthLogger traceLogger = AuthLoggerFactory.getAuthLogger();
    private String user;
    private UserType userType;
    private String target;
    private TargetType targetType;
    private RiskLevel riskLevel;
    private InterceptType interceptType;
    private Map<String, String[]> param;
    private Cookie[] cookies;
    private Object costTime;
    private Object httpStatus;
    private String userAgent;
    private String contentType;
    private Object responseData;
    private Object extInfo;
    private String appName = this.getAppName();
    private String stackTrace;
    private static Method getRequestAttributesMethod;
    private static Class<?> servletRequestAttributesClass;
    private static Method getRequestMethod;
    private static boolean isServletPresent;

    public AuthorizationLoggerImpl() {
    }

    public AuthorizationLoggerImpl(String user, UserType userType, String target, TargetType targetType, RiskLevel riskLevel) {
        this();
        this.logUser(user, userType);
        this.logTarget(target, targetType);
        this.logRiskLevel(riskLevel);
    }

    public AuthorizationLogger setLogStackTrace(boolean enabled) {
        this.logStackTrace = enabled;
        return this;
    }

    private String getAppName() {
        String appName = System.getProperty("project.name");
        if (appName == null || appName.length() == 0) {
            return "noName";
        }
        return appName;
    }

    public AuthorizationLogger logUser(String user, UserType userType) {
        this.user = user;
        this.userType = userType;
        return this;
    }

    public AuthorizationLogger logTarget(String target, TargetType targetType) {
        this.target = target;
        this.targetType = targetType;
        return this;
    }

    public AuthorizationLogger logRiskLevel(RiskLevel riskLevel) {
        this.riskLevel = riskLevel;
        return this;
    }

    public AuthorizationLogger logInterceptType(InterceptType interceptType) {
        this.interceptType = interceptType;
        return this;
    }

    public AuthorizationLogger logParam(Map<String, String[]> param) {
        this.param = param;
        return this;
    }

    public AuthorizationLogger logCookies(Cookie ... cookies) {
        this.cookies = cookies;
        return this;
    }

    public AuthorizationLogger logCookies(Set<String> cookieFilter, Cookie ... cookies) {
        if (cookieFilter == null || cookieFilter.isEmpty()) {
            return this;
        }
        ArrayList<Cookie> filterCookies = new ArrayList<Cookie>(cookieFilter.size());
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieFilter.contains(cookie.getName())) continue;
                filterCookies.add(cookie);
            }
        }
        this.cookies = filterCookies.toArray(new Cookie[filterCookies.size()]);
        return this;
    }

    public AuthorizationLogger logCostTime(Object costTime) {
        this.costTime = costTime;
        return this;
    }

    public AuthorizationLogger logHttpStatus(Object httpStatus) {
        this.httpStatus = httpStatus;
        return this;
    }

    public AuthorizationLogger logUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public AuthorizationLogger logContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public AuthorizationLogger logResponseData(Object responseData) {
        this.responseData = responseData;
        return this;
    }

    public AuthorizationLogger logExtInfo(Object extInfo) {
        this.extInfo = extInfo;
        return this;
    }

    public AuthorizationLogger logAppName(String appName) {
        this.appName = appName;
        return this;
    }

    private void logRequestAutomatically() {
        block10: {
            if (!isServletPresent || getRequestAttributesMethod == null || servletRequestAttributesClass == null || getRequestMethod == null) {
                return;
            }
            try {
                Object requestAttributes = getRequestAttributesMethod.invoke(null, new Object[0]);
                if (!servletRequestAttributesClass.isInstance(requestAttributes)) {
                    return;
                }
                Object request = getRequestMethod.invoke(requestAttributes, new Object[0]);
                if (!(request instanceof HttpServletRequest)) {
                    return;
                }
                HttpServletRequest servletRequest = (HttpServletRequest)request;
                if (this.param == null) {
                    this.logParam(servletRequest.getParameterMap());
                }
                if (this.userAgent == null) {
                    this.logUserAgent(servletRequest.getHeader("User-Agent"));
                }
                if (this.contentType == null) {
                    this.logContentType(servletRequest.getContentType());
                }
                RequestInfo requestInfo = new RequestInfo(servletRequest);
                if (this.extInfo == null) {
                    this.logExtInfo(requestInfo);
                } else {
                    this.extInfo = this.extInfo + "--" + requestInfo;
                }
            }
            catch (Throwable e) {
                logger.warn("log request error", e);
                if (e.getCause() == null || e.getCause().getMessage() == null || !e.getCause().getMessage().contains("No thread-bound request")) break block10;
                isServletPresent = false;
            }
        }
    }

    public void log() {
        try {
            if (this.logStackTrace) {
                StringBuilder sb = new StringBuilder();
                Throwable t = new Throwable();
                for (StackTraceElement element : t.getStackTrace()) {
                    sb.append(element.getClassName()).append(".").append(element.getMethodName()).append("(").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")\\n");
                }
                this.stackTrace = sb.toString();
            }
            this.logRequestAutomatically();
            this.traceLogger.setAppName(this.appName);
            this.traceLogger.logLine(this.createLogLine().toString());
        }
        catch (Throwable e) {
            logger.warn("auth log error", e);
        }
    }

    private StringBuilder createLogLine() {
        StringBuilder appender = new StringBuilder(512);
        for (Serializable serializable : Arrays.asList(this.user, this.userType, this.target, this.targetType, this.riskLevel, this.interceptType)) {
            appender.append("@@");
            this.appendWithNullCheck(serializable, "-", appender);
        }
        appender.append("@@");
        if (this.param != null) {
            int count = 0;
            for (Map.Entry<String, String[]> entry : this.param.entrySet()) {
                if (entry == null) continue;
                if (count != 0) {
                    appender.append('&');
                }
                ++count;
                appender.append(entry.getKey() == null ? "null" : entry.getKey());
                appender.append('=');
                Object[] values = entry.getValue();
                if (values == null || values.length < 1) {
                    appender.append("null");
                    continue;
                }
                if (values.length == 1) {
                    appender.append(values[0]);
                    continue;
                }
                for (int i = 0; i < values.length; ++i) {
                    if (i == 0) {
                        appender.append('[');
                    }
                    appender.append(values[i]);
                    if (i != values.length - 1) {
                        appender.append(',');
                        continue;
                    }
                    appender.append(']');
                }
            }
        }
        appender.append("@@");
        if (this.cookies != null) {
            int count = 0;
            for (Cookie cookie : this.cookies) {
                if (count != 0) {
                    appender.append(',');
                }
                ++count;
                appender.append(cookie.getName()).append('=').append(cookie.getValue());
            }
        }
        for (Object object : Arrays.asList(this.costTime, this.httpStatus, this.userAgent, this.contentType, this.responseData, this.extInfo, this.stackTrace)) {
            appender.append("@@");
            this.appendWithNullCheck(object, "-", appender);
        }
        return appender;
    }

    static {
        try {
            Class.forName("javax.servlet.http.HttpServletRequest");
            Class<?> requestContextHolderClass = Class.forName("org.springframework.web.context.request.RequestContextHolder");
            getRequestAttributesMethod = requestContextHolderClass.getDeclaredMethod("currentRequestAttributes", new Class[0]);
            servletRequestAttributesClass = Class.forName("org.springframework.web.context.request.ServletRequestAttributes");
            getRequestMethod = servletRequestAttributesClass.getDeclaredMethod("getRequest", new Class[0]);
            isServletPresent = true;
        }
        catch (Throwable e) {
            isServletPresent = false;
        }
    }
}

