/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.authorization;

import com.aliyun.securitysdk.authorization.AuthLogger;
import com.aliyun.securitysdk.authorization.EagleEyeAuthLoggerAdaptor;
import com.aliyun.securitysdk.authorization.SimpleAuthLogger;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import com.aliyun.securitysdk.util.StringUtils;
import com.taobao.eagleeye.EagleEye;
import com.taobao.eagleeye.TraceLogger;
import com.taobao.eagleeye.TraceLoggerBuilder;
import java.io.File;

public class AuthLoggerFactory {
    public static AuthLogger logger;

    public static AuthLogger getAuthLogger() {
        if (logger == null) {
            if (ClassUtils.isPresent((String)"com.taobao.eagleeye.EagleEye", (ClassLoader)ClassUtils.getDefaultClassLoader()) && ClassUtils.isPresent((String)"com.taobao.eagleeye.TraceLoggerBuilder", (ClassLoader)ClassUtils.getDefaultClassLoader())) {
                String filePath = System.getProperty("security.auth.log.path");
                if (StringUtils.isBlank(filePath)) {
                    filePath = AuthLoggerFactory.locateUserHome() + "logs" + File.separator + "security" + File.separator;
                } else if (!filePath.endsWith(File.separator)) {
                    filePath = filePath + File.separator;
                }
                TraceLoggerBuilder loggerBuilder = (TraceLoggerBuilder)((TraceLoggerBuilder)((TraceLoggerBuilder)((TraceLoggerBuilder)EagleEye.traceLoggerBuilder((String)"authorization").entryDelimiter('|')).appFilePath(filePath + "rass.authorization.log")).maxFileSizeMB(200L)).maxBackupIndex(5);
                try {
                    loggerBuilder.charset("UTF-8");
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                TraceLogger l = loggerBuilder.buildSingleton();
                logger = new EagleEyeAuthLoggerAdaptor(l);
            } else {
                logger = new SimpleAuthLogger();
            }
        }
        return logger;
    }

    private static String locateUserHome() {
        String userHome = System.getProperty("user.home");
        if (userHome != null && !userHome.isEmpty()) {
            if (!userHome.endsWith(File.separator)) {
                userHome = userHome + File.separator;
            }
        } else {
            userHome = "/tmp/";
        }
        return userHome;
    }
}

