/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerManager;
import java.util.HashMap;
import java.util.Map;

public class CreateTriggerAction
implements TriggerAction {
    public static final String type = "CreateTriggerAction";
    private static TriggerManager triggerManager;
    private final Trigger trigger;
    private final String actionId;
    private Map<String, Object> context;

    public CreateTriggerAction(String actionId, Trigger trigger) {
        this.actionId = actionId;
        this.trigger = trigger;
    }

    public static void setTriggerManager(TriggerManager trm) {
        triggerManager = trm;
    }

    public static CreateTriggerAction createFromJson(Object obj) throws Exception {
        HashMap jsonObj = (HashMap)obj;
        if (!jsonObj.get("type").equals(type)) {
            throw new Exception("Cannot create action of CreateTriggerAction from " + jsonObj.get("type"));
        }
        String actionId = (String)jsonObj.get("actionId");
        Trigger trigger = Trigger.fromJson(jsonObj.get("trigger"));
        return new CreateTriggerAction(actionId, trigger);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public CreateTriggerAction fromJson(Object obj) throws Exception {
        return CreateTriggerAction.createFromJson(obj);
    }

    @Override
    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("actionId", this.actionId);
        jsonObj.put("type", type);
        jsonObj.put("trigger", this.trigger.toJson());
        return jsonObj;
    }

    @Override
    public void doAction() throws Exception {
        triggerManager.insertTrigger(this.trigger);
    }

    @Override
    public String getDescription() {
        return "create another: " + this.trigger.getDescription();
    }

    @Override
    public String getId() {
        return this.actionId;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }
}

