/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project.validator;

import azkaban.project.validator.ValidationStatus;
import java.util.HashSet;
import java.util.Set;

public class ValidationReport {
    protected ValidationStatus _status = ValidationStatus.PASS;
    protected Set<String> _infoMsgs = new HashSet<String>();
    protected Set<String> _warningMsgs = new HashSet<String>();
    protected Set<String> _errorMsgs = new HashSet<String>();

    public static ValidationStatus getInfoMsgLevel(String msg) {
        if (msg.startsWith("ERROR")) {
            return ValidationStatus.ERROR;
        }
        if (msg.startsWith("WARN")) {
            return ValidationStatus.WARN;
        }
        return ValidationStatus.PASS;
    }

    public static String getInfoMsg(String msg) {
        if (msg.startsWith("ERROR")) {
            return msg.replaceFirst("ERROR", "");
        }
        if (msg.startsWith("WARN")) {
            return msg.replaceFirst("WARN", "");
        }
        return msg;
    }

    public void addWarnLevelInfoMsg(String msg) {
        if (msg != null) {
            this._infoMsgs.add("WARN" + msg);
        }
    }

    public void addErrorLevelInfoMsg(String msg) {
        if (msg != null) {
            this._infoMsgs.add("ERROR" + msg);
        }
    }

    public void addWarningMsgs(Set<String> msgs) {
        if (msgs != null) {
            this._warningMsgs.addAll(msgs);
            if (!msgs.isEmpty() && this._errorMsgs.isEmpty()) {
                this._status = ValidationStatus.WARN;
            }
        }
    }

    public void addErrorMsgs(Set<String> msgs) {
        if (msgs != null) {
            this._errorMsgs.addAll(msgs);
            if (!msgs.isEmpty()) {
                this._status = ValidationStatus.ERROR;
            }
        }
    }

    public ValidationStatus getStatus() {
        return this._status;
    }

    public Set<String> getInfoMsgs() {
        return this._infoMsgs;
    }

    public Set<String> getWarningMsgs() {
        return this._warningMsgs;
    }

    public Set<String> getErrorMsgs() {
        return this._errorMsgs;
    }
}

