/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.db.EncodingType;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.project.ProjectFileHandler;
import azkaban.project.ProjectLogEvent;
import azkaban.user.Permission;
import azkaban.utils.GZIPUtils;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Triple;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;

class JdbcProjectHandlerSet {
    JdbcProjectHandlerSet() {
    }

    public static class FlowFileResultHandler
    implements ResultSetHandler<List<byte[]>> {
        public static String SELECT_FLOW_FILE = "SELECT flow_file FROM project_flow_files WHERE project_id=? AND project_version=? AND flow_name=? AND flow_version=?";
        public static String SELECT_ALL_FLOW_FILES = "SELECT flow_file FROM project_flow_files WHERE project_id=? AND project_version=?";

        public List<byte[]> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<byte[]> data = new ArrayList<byte[]>();
            do {
                byte[] bytes = rs.getBytes(1);
                data.add(bytes);
            } while (rs.next());
            return data;
        }
    }

    public static class IntHandler
    implements ResultSetHandler<Integer> {
        public static String SELECT_LATEST_VERSION = "SELECT MAX(version) FROM project_versions WHERE project_id=?";
        public static String SELECT_LATEST_FLOW_VERSION = "SELECT MAX(flow_version) FROM project_flow_files WHERE project_id=? AND project_version=? AND flow_name=?";

        public Integer handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return 0;
            }
            return rs.getInt(1);
        }
    }

    public static class ProjectVersionResultHandler
    implements ResultSetHandler<List<ProjectFileHandler>> {
        public static String SELECT_PROJECT_VERSION = "SELECT project_id, version, upload_time, uploader, file_type, file_name, md5, num_chunks, resource_id FROM project_versions WHERE project_id=? AND version=?";

        public List<ProjectFileHandler> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return null;
            }
            ArrayList<ProjectFileHandler> handlers = new ArrayList<ProjectFileHandler>();
            do {
                int projectId = rs.getInt(1);
                int version = rs.getInt(2);
                long uploadTime = rs.getLong(3);
                String uploader = rs.getString(4);
                String fileType = rs.getString(5);
                String fileName = rs.getString(6);
                byte[] md5 = rs.getBytes(7);
                int numChunks = rs.getInt(8);
                String resourceId = rs.getString(9);
                ProjectFileHandler handler = new ProjectFileHandler(projectId, version, uploadTime, uploader, fileType, fileName, numChunks, md5, resourceId);
                handlers.add(handler);
            } while (rs.next());
            return handlers;
        }
    }

    public static class ProjectFileChunkResultHandler
    implements ResultSetHandler<List<byte[]>> {
        public static String SELECT_PROJECT_CHUNKS_FILE = "SELECT project_id, version, chunk, size, file FROM project_files WHERE project_id=? AND version=? AND chunk >= ? AND chunk < ? ORDER BY chunk ASC";

        public List<byte[]> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<byte[]> data = new ArrayList<byte[]>();
            do {
                byte[] bytes = rs.getBytes(5);
                data.add(bytes);
            } while (rs.next());
            return data;
        }
    }

    public static class ProjectLogsResultHandler
    implements ResultSetHandler<List<ProjectLogEvent>> {
        public static String SELECT_PROJECT_EVENTS_ORDER = "SELECT project_id, event_type, event_time, username, message FROM project_events WHERE project_id=? ORDER BY event_time DESC LIMIT ? OFFSET ?";

        public List<ProjectLogEvent> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<ProjectLogEvent> events = new ArrayList<ProjectLogEvent>();
            do {
                int projectId = rs.getInt(1);
                int eventType = rs.getInt(2);
                long eventTime = rs.getLong(3);
                String username = rs.getString(4);
                String message = rs.getString(5);
                ProjectLogEvent event = new ProjectLogEvent(projectId, ProjectLogEvent.EventType.fromInteger(eventType), eventTime, username, message);
                events.add(event);
            } while (rs.next());
            return events;
        }
    }

    public static class ProjectPropertiesResultsHandler
    implements ResultSetHandler<List<Pair<String, Props>>> {
        public static String SELECT_PROJECT_PROPERTY = "SELECT project_id, version, name, modified_time, encoding_type, property FROM project_properties WHERE project_id=? AND version=? AND name=?";
        public static String SELECT_PROJECT_PROPERTIES = "SELECT project_id, version, name, modified_time, encoding_type, property FROM project_properties WHERE project_id=? AND version=?";

        public List<Pair<String, Props>> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<Pair<String, Props>> properties = new ArrayList<Pair<String, Props>>();
            do {
                String name = rs.getString(3);
                int eventType = rs.getInt(5);
                byte[] dataBytes = rs.getBytes(6);
                EncodingType encType = EncodingType.fromInteger((int)eventType);
                String propertyString = null;
                try {
                    propertyString = encType == EncodingType.GZIP ? GZIPUtils.unGzipString(dataBytes, "UTF-8") : new String(dataBytes, "UTF-8");
                    Props props = PropsUtils.fromJSONString((String)propertyString);
                    props.setSource(name);
                    properties.add(new Pair<String, Props>(name, props));
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            } while (rs.next());
            return properties;
        }
    }

    public static class ProjectFlowsResultHandler
    implements ResultSetHandler<List<Flow>> {
        public static String SELECT_PROJECT_FLOW = "SELECT project_id, version, flow_id, modified_time, encoding_type, json FROM project_flows WHERE project_id=? AND version=? AND flow_id=?";
        public static String SELECT_ALL_PROJECT_FLOWS = "SELECT project_id, version, flow_id, modified_time, encoding_type, json FROM project_flows WHERE project_id=? AND version=?";

        public List<Flow> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<Flow> flows = new ArrayList<Flow>();
            do {
                String flowId = rs.getString(3);
                int encodingType = rs.getInt(5);
                byte[] dataBytes = rs.getBytes(6);
                if (dataBytes == null) continue;
                EncodingType encType = EncodingType.fromInteger((int)encodingType);
                Object flowObj = null;
                try {
                    String jsonString;
                    if (encType == EncodingType.GZIP) {
                        jsonString = GZIPUtils.unGzipString(dataBytes, "UTF-8");
                        flowObj = JSONUtils.parseJSONFromString((String)jsonString);
                    } else {
                        jsonString = new String(dataBytes, "UTF-8");
                        flowObj = JSONUtils.parseJSONFromString((String)jsonString);
                    }
                    Flow flow = Flow.flowFromObject(flowObj);
                    flows.add(flow);
                }
                catch (IOException e) {
                    throw new SQLException("Error retrieving flow data " + flowId, e);
                }
            } while (rs.next());
            return flows;
        }
    }

    public static class ProjectPermissionsResultHandler
    implements ResultSetHandler<List<Triple<String, Boolean, Permission>>> {
        public static String SELECT_PROJECT_PERMISSION = "SELECT project_id, modified_time, name, permissions, isGroup FROM project_permissions WHERE project_id=?";

        public List<Triple<String, Boolean, Permission>> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<Triple<String, Boolean, Permission>> permissions = new ArrayList<Triple<String, Boolean, Permission>>();
            do {
                String username = rs.getString(3);
                int permissionFlag = rs.getInt(4);
                boolean val = rs.getBoolean(5);
                Permission perm = new Permission(permissionFlag);
                permissions.add(new Triple<String, Boolean, Permission>(username, val, perm));
            } while (rs.next());
            return permissions;
        }
    }

    public static class ProjectResultHandler
    implements ResultSetHandler<List<Project>> {
        public static String SELECT_PROJECT_BY_NAME = "SELECT id, name, active, modified_time, create_time, version, last_modified_by, description, enc_type, settings_blob FROM projects WHERE name=?";
        public static String SELECT_PROJECT_BY_ID = "SELECT id, name, active, modified_time, create_time, version, last_modified_by, description, enc_type, settings_blob FROM projects WHERE id=?";
        public static String SELECT_ALL_ACTIVE_PROJECTS = "SELECT id, name, active, modified_time, create_time, version, last_modified_by, description, enc_type, settings_blob FROM projects WHERE active=true";
        public static String SELECT_ACTIVE_PROJECT_BY_NAME = "SELECT id, name, active, modified_time, create_time, version, last_modified_by, description, enc_type, settings_blob FROM projects WHERE name=? AND active=true";

        public List<Project> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<Project> projects = new ArrayList<Project>();
            do {
                Project project;
                int id = rs.getInt(1);
                String name = rs.getString(2);
                boolean active = rs.getBoolean(3);
                long modifiedTime = rs.getLong(4);
                long createTime = rs.getLong(5);
                int version = rs.getInt(6);
                String lastModifiedBy = rs.getString(7);
                String description = rs.getString(8);
                int encodingType = rs.getInt(9);
                byte[] data = rs.getBytes(10);
                if (data != null) {
                    EncodingType encType = EncodingType.fromInteger((int)encodingType);
                    try {
                        Object blobObj;
                        String jsonString;
                        if (encType == EncodingType.GZIP) {
                            jsonString = GZIPUtils.unGzipString(data, "UTF-8");
                            blobObj = JSONUtils.parseJSONFromString((String)jsonString);
                        } else {
                            jsonString = new String(data, "UTF-8");
                            blobObj = JSONUtils.parseJSONFromString((String)jsonString);
                        }
                        project = Project.projectFromObject(blobObj);
                    }
                    catch (IOException e) {
                        throw new SQLException("Failed to get project.", e);
                    }
                } else {
                    project = new Project(id, name);
                }
                project.setActive(active);
                project.setLastModifiedTimestamp(modifiedTime);
                project.setCreateTimestamp(createTime);
                project.setVersion(version);
                project.setLastModifiedUser(lastModifiedBy);
                project.setDescription(description);
                projects.add(project);
            } while (rs.next());
            return projects;
        }
    }
}

