/*
 * Decompiled with CFR 0.152.
 */
package azkaban.metric;

import azkaban.metric.IMetric;
import azkaban.metric.IMetricEmitter;
import azkaban.metric.MetricException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class MetricReportManager {
    private static final int MAX_EMITTER_THREADS = 4;
    private static final Logger logger = Logger.getLogger(MetricReportManager.class);
    private static volatile MetricReportManager instance = null;
    private static volatile boolean isManagerEnabled;
    private final List<IMetric<?>> metrics;
    private final List<IMetricEmitter> metricEmitters;
    private final ExecutorService executorService;

    private MetricReportManager() {
        logger.debug((Object)"Instantiating Metric Manager");
        this.executorService = Executors.newFixedThreadPool(4);
        this.metrics = new ArrayList();
        this.metricEmitters = new LinkedList<IMetricEmitter>();
        this.enableManager();
    }

    public static boolean isAvailable() {
        return MetricReportManager.isInstantiated() && isManagerEnabled;
    }

    public static boolean isInstantiated() {
        return instance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetricReportManager getInstance() {
        if (instance != null) return instance;
        Class<MetricReportManager> clazz = MetricReportManager.class;
        synchronized (MetricReportManager.class) {
            if (instance != null) return instance;
            logger.info((Object)"Instantiating MetricReportManager");
            instance = new MetricReportManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMetric(IMetric<?> metric) {
        if (metric != null && MetricReportManager.isAvailable()) {
            try {
                IMetric<?> metricSnapshot;
                IMetric<?> iMetric = metric;
                synchronized (iMetric) {
                    metricSnapshot = metric.getSnapshot();
                }
                logger.debug((Object)String.format("Submitting %s metric for metric emission pool", metricSnapshot.getName()));
                for (IMetricEmitter metricEmitter : this.metricEmitters) {
                    this.executorService.submit(() -> {
                        try {
                            metricEmitter.reportMetric(metricSnapshot);
                        }
                        catch (Exception ex) {
                            logger.error((Object)String.format("Failed to report %s metric due to ", metricSnapshot.getName()), (Throwable)ex);
                        }
                    });
                }
            }
            catch (CloneNotSupportedException ex) {
                logger.error((Object)String.format("Failed to take snapshot for %s metric", metric.getClass().getName()), (Throwable)ex);
            }
        }
    }

    public void addMetricEmitter(IMetricEmitter emitter) {
        this.metricEmitters.add(emitter);
    }

    public void removeMetricEmitter(IMetricEmitter emitter) {
        this.metricEmitters.remove(emitter);
    }

    public List<IMetricEmitter> getMetricEmitters() {
        return this.metricEmitters;
    }

    public void addMetric(IMetric<?> metric) {
        if (metric == null) {
            throw new IllegalArgumentException("Cannot add a null metric");
        }
        if (this.getMetricFromName(metric.getName()) == null) {
            logger.debug((Object)String.format("Adding %s metric in Metric Manager", metric.getName()));
            this.metrics.add(metric);
            metric.updateMetricManager(this);
        } else {
            logger.error((Object)"Failed to add metric");
        }
    }

    public IMetric<?> getMetricFromName(String name) {
        IMetric<?> metric = null;
        if (name != null) {
            for (IMetric<?> currentMetric : this.metrics) {
                if (!currentMetric.getName().equals(name)) continue;
                metric = currentMetric;
                break;
            }
        }
        return metric;
    }

    public List<IMetric<?>> getAllMetrics() {
        return this.metrics;
    }

    public void enableManager() {
        logger.info((Object)"Enabling Metric Manager");
        isManagerEnabled = true;
    }

    public void disableManager() {
        logger.info((Object)"Disabling Metric Manager");
        if (isManagerEnabled) {
            isManagerEnabled = false;
            for (IMetricEmitter emitter : this.metricEmitters) {
                try {
                    emitter.purgeAllData();
                }
                catch (MetricException ex) {
                    logger.error((Object)"Failed to purge data ", (Throwable)ex);
                }
            }
        }
    }

    protected void finalize() {
        this.executorService.shutdown();
    }
}

