/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobtype;

import azkaban.jobExecutor.JavaProcessJob;
import azkaban.jobExecutor.Job;
import azkaban.jobExecutor.NoopJob;
import azkaban.jobExecutor.ProcessJob;
import azkaban.jobExecutor.utils.JobExecutionException;
import azkaban.jobtype.JobTypeManagerException;
import azkaban.jobtype.JobTypePluginSet;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class JobTypeManager {
    public static final String DEFAULT_JOBTYPEPLUGINDIR = "plugins/jobtypes";
    private static final String JOBTYPECONFFILE = "plugin.properties";
    private static final String JOBTYPESYSCONFFILE = "private.properties";
    private static final String COMMONCONFFILE = "common.properties";
    private static final String COMMONSYSCONFFILE = "commonprivate.properties";
    private static final Logger logger = Logger.getLogger(JobTypeManager.class);
    private final String jobTypePluginDir;
    private final ClassLoader parentLoader;
    private final Props globalProperties;
    private JobTypePluginSet pluginSet;

    public JobTypeManager(String jobtypePluginDir, Props globalProperties, ClassLoader parentClassLoader) {
        this.jobTypePluginDir = jobtypePluginDir;
        this.parentLoader = parentClassLoader;
        this.globalProperties = globalProperties;
        this.loadPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPlugins() throws JobTypeManagerException {
        File pluginDir;
        JobTypePluginSet plugins = new JobTypePluginSet();
        this.loadDefaultTypes(plugins);
        if (this.jobTypePluginDir != null && (pluginDir = new File(this.jobTypePluginDir)).exists()) {
            logger.info((Object)("Job type plugin directory set. Loading extra job types from " + pluginDir));
            try {
                this.loadPluginJobTypes(plugins);
            }
            catch (Exception e) {
                logger.info((Object)("Plugin jobtypes failed to load. " + e.getCause()), (Throwable)e);
                throw new JobTypeManagerException(e);
            }
        }
        JobTypeManager jobTypeManager = this;
        synchronized (jobTypeManager) {
            this.pluginSet = plugins;
        }
    }

    private void loadDefaultTypes(JobTypePluginSet plugins) throws JobTypeManagerException {
        logger.info((Object)"Loading plugin default job types");
        plugins.addPluginClass("command", ProcessJob.class);
        plugins.addPluginClass("javaprocess", JavaProcessJob.class);
        plugins.addPluginClass("noop", NoopJob.class);
    }

    private void loadPluginJobTypes(JobTypePluginSet plugins) throws JobTypeManagerException {
        File jobPluginsDir = new File(this.jobTypePluginDir);
        if (!jobPluginsDir.exists()) {
            logger.error((Object)("Job type plugin dir " + this.jobTypePluginDir + " doesn't exist. Will not load any external plugins."));
            return;
        }
        if (!jobPluginsDir.isDirectory()) {
            throw new JobTypeManagerException("Job type plugin dir " + this.jobTypePluginDir + " is not a directory!");
        }
        if (!jobPluginsDir.canRead()) {
            throw new JobTypeManagerException("Job type plugin dir " + this.jobTypePluginDir + " is not readable!");
        }
        Props commonPluginJobProps = null;
        File commonJobPropsFile = new File(jobPluginsDir, COMMONCONFFILE);
        if (commonJobPropsFile.exists()) {
            logger.info((Object)("Common plugin job props file " + commonJobPropsFile + " found. Attempt to load."));
            try {
                commonPluginJobProps = new Props(this.globalProperties, commonJobPropsFile);
            }
            catch (IOException e) {
                throw new JobTypeManagerException("Failed to load common plugin job properties" + e.getCause());
            }
        } else {
            logger.info((Object)("Common plugin job props file " + commonJobPropsFile + " not found. Using only globals props"));
            commonPluginJobProps = new Props(this.globalProperties);
        }
        Props commonPluginLoadProps = null;
        File commonLoadPropsFile = new File(jobPluginsDir, COMMONSYSCONFFILE);
        if (commonLoadPropsFile.exists()) {
            logger.info((Object)("Common plugin load props file " + commonLoadPropsFile + " found. Attempt to load."));
            try {
                commonPluginLoadProps = new Props(null, commonLoadPropsFile);
            }
            catch (IOException e) {
                throw new JobTypeManagerException("Failed to load common plugin loader properties" + e.getCause());
            }
        } else {
            logger.info((Object)("Common plugin load props file " + commonLoadPropsFile + " not found. Using empty props."));
            commonPluginLoadProps = new Props();
        }
        plugins.setCommonPluginJobProps(commonPluginJobProps);
        plugins.setCommonPluginLoadProps(commonPluginLoadProps);
        for (File dir : jobPluginsDir.listFiles()) {
            if (!dir.isDirectory() || !dir.canRead()) continue;
            try {
                this.loadJobTypes(dir, plugins);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to load jobtype " + dir.getName() + e.getMessage()), (Throwable)e);
                throw new JobTypeManagerException(e);
            }
        }
    }

    private void loadJobTypes(File pluginDir, JobTypePluginSet plugins) throws JobTypeManagerException {
        String jobTypeName = pluginDir.getName();
        logger.info((Object)("Loading plugin " + jobTypeName));
        Props pluginJobProps = null;
        Props pluginLoadProps = null;
        File pluginJobPropsFile = new File(pluginDir, JOBTYPECONFFILE);
        File pluginLoadPropsFile = new File(pluginDir, JOBTYPESYSCONFFILE);
        if (!pluginLoadPropsFile.exists()) {
            logger.info((Object)("Plugin load props file " + pluginLoadPropsFile + " not found."));
            return;
        }
        try {
            Props commonPluginJobProps = plugins.getCommonPluginJobProps();
            Props commonPluginLoadProps = plugins.getCommonPluginLoadProps();
            pluginJobProps = pluginJobPropsFile.exists() ? new Props(commonPluginJobProps, pluginJobPropsFile) : new Props(commonPluginJobProps);
            pluginLoadProps = new Props(commonPluginLoadProps, pluginLoadPropsFile);
            pluginLoadProps.put("plugin.dir", pluginDir.getAbsolutePath());
            pluginJobProps.put("plugin.dir", pluginDir.getAbsolutePath());
            pluginLoadProps = PropsUtils.resolveProps((Props)pluginLoadProps);
        }
        catch (Exception e) {
            logger.error((Object)("pluginLoadProps to help with debugging: " + pluginLoadProps));
            throw new JobTypeManagerException("Failed to get jobtype properties" + e.getMessage(), e);
        }
        plugins.addPluginLoadProps(jobTypeName, pluginLoadProps);
        if (pluginJobProps != null) {
            plugins.addPluginJobProps(jobTypeName, pluginJobProps);
        }
        ClassLoader jobTypeLoader = this.loadJobTypeClassLoader(pluginDir, jobTypeName, plugins);
        String jobtypeClass = pluginLoadProps.get((Object)"jobtype.class");
        Class<?> clazz = null;
        try {
            clazz = jobTypeLoader.loadClass(jobtypeClass);
            plugins.addPluginClass(jobTypeName, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new JobTypeManagerException(e);
        }
        logger.info((Object)("Verifying job plugin " + jobTypeName));
        try {
            Props fakeSysProps = new Props(pluginLoadProps);
            Props fakeJobProps = new Props(pluginJobProps);
            Job job = (Job)Utils.callConstructor(clazz, (Object[])new Object[]{"dummy", fakeSysProps, fakeJobProps, logger});
        }
        catch (Throwable t) {
            logger.info((Object)("Jobtype " + jobTypeName + " failed test!"), t);
            throw new JobExecutionException(t);
        }
        logger.info((Object)("Loaded jobtype " + jobTypeName + " " + jobtypeClass));
    }

    private ClassLoader loadJobTypeClassLoader(File pluginDir, String jobTypeName, JobTypePluginSet plugins) {
        ArrayList<URL> resources = new ArrayList<URL>();
        Props pluginLoadProps = plugins.getPluginLoaderProps(jobTypeName);
        try {
            List jobtypeLibDirs;
            logger.info((Object)("Adding global resources for " + jobTypeName));
            List typeGlobalClassPath = pluginLoadProps.getStringList("jobtype.global.classpath", null, ",");
            if (typeGlobalClassPath != null) {
                for (Object jar : typeGlobalClassPath) {
                    URL cpItem = new File((String)jar).toURI().toURL();
                    if (resources.contains(cpItem)) continue;
                    logger.info((Object)("adding to classpath " + cpItem));
                    resources.add(cpItem);
                }
            }
            logger.info((Object)"Adding type resources.");
            List typeClassPath = pluginLoadProps.getStringList("jobtype.classpath", null, ",");
            if (typeClassPath != null) {
                for (String jar : typeClassPath) {
                    URL cpItem = new File(jar).toURI().toURL();
                    if (resources.contains(cpItem)) continue;
                    logger.info((Object)("adding to classpath " + cpItem));
                    resources.add(cpItem);
                }
            }
            if ((jobtypeLibDirs = pluginLoadProps.getStringList("jobtype.lib.dir", null, ",")) != null) {
                for (String libDir : jobtypeLibDirs) {
                    for (File f : new File(libDir).listFiles()) {
                        if (!f.getName().endsWith(".jar")) continue;
                        resources.add(f.toURI().toURL());
                        logger.info((Object)("adding to classpath " + f.toURI().toURL()));
                    }
                }
            }
            logger.info((Object)"Adding type override resources.");
            for (File f : pluginDir.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                resources.add(f.toURI().toURL());
                logger.info((Object)("adding to classpath " + f.toURI().toURL()));
            }
        }
        catch (MalformedURLException e) {
            throw new JobTypeManagerException(e);
        }
        logger.info((Object)String.format("Classpath for plugin[dir: %s, JobType: %s]: %s", pluginDir, jobTypeName, resources));
        URLClassLoader jobTypeLoader = new URLClassLoader(resources.toArray(new URL[resources.size()]), this.parentLoader);
        return jobTypeLoader;
    }

    public Job buildJobExecutor(String jobId, Props jobProps, Logger logger) throws JobTypeManagerException {
        JobTypePluginSet pluginSet = this.getJobTypePluginSet();
        Job job = null;
        try {
            String jobType = jobProps.getString("type");
            if (jobType == null || jobType.length() == 0) {
                throw new JobExecutionException(String.format("The 'type' parameter for job[%s] is null or empty", jobProps));
            }
            logger.info((Object)("Building " + jobType + " job executor. "));
            Class<? extends Job> executorClass = pluginSet.getPluginClass(jobType);
            if (executorClass == null) {
                throw new JobExecutionException(String.format("Job type '" + jobType + "' is unrecognized. Could not construct job[%s] of type[%s].", jobProps, jobType));
            }
            Props pluginJobProps = pluginSet.getPluginJobProps(jobType);
            if (pluginJobProps == null) {
                pluginJobProps = pluginSet.getCommonPluginJobProps();
            }
            if (pluginJobProps != null) {
                for (String k : pluginJobProps.getKeySet()) {
                    if (jobProps.containsKey((Object)k)) continue;
                    jobProps.put(k, pluginJobProps.get((Object)k));
                }
            }
            jobProps = PropsUtils.resolveProps((Props)jobProps);
            Props pluginLoadProps = pluginSet.getPluginLoaderProps(jobType);
            if (pluginLoadProps != null) {
                pluginLoadProps = PropsUtils.resolveProps((Props)pluginLoadProps);
            } else {
                pluginLoadProps = pluginSet.getCommonPluginLoadProps();
                if (pluginLoadProps == null) {
                    pluginLoadProps = new Props();
                }
            }
            job = (Job)Utils.callConstructor(executorClass, (Object[])new Object[]{jobId, pluginLoadProps, jobProps, logger});
        }
        catch (Exception e) {
            logger.error((Object)("Failed to build job executor for job " + jobId + e.getMessage()));
            throw new JobTypeManagerException("Failed to build job executor for job " + jobId, e);
        }
        catch (Throwable t) {
            logger.error((Object)("Failed to build job executor for job " + jobId + t.getMessage()), t);
            throw new JobTypeManagerException("Failed to build job executor for job " + jobId, t);
        }
        return job;
    }

    public synchronized JobTypePluginSet getJobTypePluginSet() {
        return this.pluginSet;
    }
}

